/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.response;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.n52.io.response.GeometryType;

public class GeometryTypeTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void when_extractingId_then_typePrefixGone() {
        Assert.assertThat((Object)GeometryType.extractId((String)"observed_static_foobar"), (Matcher)Matchers.is((Object)"foobar"));
    }

    @Test
    public void when_extractingWithInvalidPrefix_then_expectIdentity() {
        Assert.assertThat((Object)GeometryType.extractId((String)"invalid_prefix"), (Matcher)Matchers.is((Object)"invalid_prefix"));
    }

    @Test
    public void when_observedGeometryOnlyPrefix_then_expectIdentity() {
        Assert.assertThat((Object)GeometryType.extractId((String)"observed_static"), (Matcher)Matchers.is((Object)"observed_static"));
    }

    @Test
    public void when_observedOnlyPrefix_then_expectIdentity() {
        Assert.assertThat((Object)GeometryType.extractId((String)"observed"), (Matcher)Matchers.is((Object)"observed"));
    }

    @Test
    public void when_idWithObservedPrefix_then_detectType() {
        Assert.assertTrue((boolean)GeometryType.isObservedGeometryId((String)"observed_static"));
    }

    @Test
    public void when_idWithPlatformPrefix_then_detectType() {
        Assert.assertTrue((boolean)GeometryType.isPlatformGeometryId((String)"platform_site"));
    }

    @Test
    public void when_idWithSiteSuffix_then_detectType() {
        Assert.assertTrue((boolean)GeometryType.isSiteId((String)"platform_site_10"));
    }

    @Test
    public void when_nullId_then_handledWhenDetectPlatform() {
        Assert.assertFalse((boolean)GeometryType.isPlatformGeometryId(null));
    }

    @Test
    public void when_nullId_then_handledWhenDetectSite() {
        Assert.assertFalse((boolean)GeometryType.isSiteId(null));
    }
}

