/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.n52.io.IoParseException;

public class IntervalWithTimeZone {
    private String timespan;

    public IntervalWithTimeZone(String timespan) {
        try {
            Interval.parse((String)timespan);
            this.timespan = timespan;
        }
        catch (IllegalArgumentException e) {
            String message = "Could not parse timespan parameter." + timespan;
            throw new IoParseException(message, e);
        }
    }

    public DateTimeZone getTimezone() {
        String endTime = this.timespan.split("/")[1];
        return DateTime.parse((String)endTime).getZone();
    }

    public Interval toInterval() {
        return Interval.parse((String)this.timespan);
    }

    public String toString() {
        return this.timespan;
    }
}

