/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io;

public enum MimeType {
    APPLICATION_JSON("application/json", "json"),
    APPLICATION_PDF("application/pdf", "pdf"),
    APPLICATION_ZIP("application/zip", "zip"),
    IMAGE_PNG("image/png", "png"),
    TEXT_CSV("text/csv", "csv");

    private final String mimeType;
    private final String formatName;

    private MimeType(String mimeType, String formatName) {
        this.mimeType = mimeType;
        this.formatName = formatName;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getFormatName() {
        return this.formatName;
    }

    public static boolean isKnownMimeType(String value) {
        for (MimeType type : MimeType.values()) {
            if (!type.formatName.equalsIgnoreCase(value) && !type.mimeType.equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    public static MimeType toInstance(String value) {
        for (MimeType type : MimeType.values()) {
            if (!type.formatName.equalsIgnoreCase(value) && !type.mimeType.equalsIgnoreCase(value)) continue;
            return type;
        }
        throw new IllegalArgumentException("'" + value + "' is not of type " + MimeType.class.getName());
    }

    public String toString() {
        return this.getMimeType();
    }
}

