/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.crs;

import java.io.Serializable;
import org.n52.io.geojson.old.GeojsonCrs;
import org.n52.io.geojson.old.GeojsonPoint;

class EastingNorthing
implements Serializable {
    private static final long serialVersionUID = 4080241800833286545L;
    private double easting;
    private double northing;
    private double altitude;
    private GeojsonCrs crs;

    private EastingNorthing() {
    }

    EastingNorthing(GeojsonPoint point) {
        this(point.getCoordinates(), point.getCrs());
    }

    EastingNorthing(Double easting, Double northing, String srs) {
        this(new Double[]{easting, northing}, GeojsonCrs.createNamedCRS(srs));
    }

    EastingNorthing(Double[] coordinates) {
        this(coordinates, GeojsonCrs.createNamedCRS("CRS:84"));
    }

    EastingNorthing(Double[] coordinates, GeojsonCrs crs) {
        if (coordinates == null) {
            throw new NullPointerException("Coordinates must not null.");
        }
        if (coordinates.length != 2 && coordinates.length != 3) {
            throw new IllegalArgumentException("Coordinates must be either 2- or 3-dimensional.");
        }
        this.crs = crs == null ? GeojsonCrs.createNamedCRS("CRS:84") : crs;
        this.easting = coordinates[0];
        this.northing = coordinates[1];
        if (coordinates.length == 3) {
            this.altitude = coordinates[2];
        }
    }

    double getEasting() {
        return this.easting;
    }

    double getNorthing() {
        return this.northing;
    }

    double getAltitude() {
        return this.altitude;
    }

    void setAltitude(double altitude) {
        this.altitude = altitude;
    }

    String getCrsDefinition() {
        return this.crs.getName();
    }

    GeojsonCrs getCrs() {
        return this.crs;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.altitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.easting);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.northing);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EastingNorthing)) {
            return false;
        }
        EastingNorthing other = (EastingNorthing)obj;
        if (Double.doubleToLongBits(this.altitude) != Double.doubleToLongBits(other.altitude)) {
            return false;
        }
        if (Double.doubleToLongBits(this.easting) != Double.doubleToLongBits(other.easting)) {
            return false;
        }
        return Double.doubleToLongBits(this.northing) == Double.doubleToLongBits(other.northing);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName()).append(" [ ");
        sb.append("Easting: ").append(this.easting).append(", ");
        sb.append("Northing: ").append(this.northing).append(", ");
        sb.append("Altitude: ").append(this.altitude).append(" ]");
        return sb.toString();
    }
}

