/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.geojson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.Map;
import org.n52.io.geojson.GeoJSONEncoder;
import org.n52.io.geojson.GeoJSONException;
import org.n52.io.geojson.GeoJSONFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureOutputSerializer
extends JsonSerializer<GeoJSONFeature> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureOutputSerializer.class);

    public void serialize(GeoJSONFeature value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
        if (value.isSetGeometry()) {
            this.writeFeature(value, gen);
        } else {
            this.writeGeometryLessFeature(value, gen);
        }
    }

    private void writeFeature(GeoJSONFeature value, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("type", "Feature");
        gen.writeStringField("id", value.getId());
        gen.writeObjectField("properties", value.getProperties());
        gen.writeObjectField("geometry", this.encodeGeometry(value));
        gen.writeEndObject();
    }

    private void writeGeometryLessFeature(GeoJSONFeature value, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        this.writeMap(value.getProperties(), gen);
        gen.writeEndObject();
    }

    private void writeMap(Map<String, Object> map, JsonGenerator gen) throws IOException {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            gen.writeObjectField(entry.getKey(), entry.getValue());
        }
    }

    private Object encodeGeometry(GeoJSONFeature value) {
        try {
            GeoJSONEncoder enc = new GeoJSONEncoder();
            Geometry geometry = value.getGeometry();
            return enc.encodeGeometry(geometry);
        }
        catch (GeoJSONException e) {
            LOGGER.error("could not properly encode geometry.", (Throwable)e);
            return null;
        }
    }
}

