/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.request;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.n52.io.IntervalWithTimeZone;
import org.n52.io.IoParseException;
import org.n52.io.crs.BoundingBox;
import org.n52.io.crs.CRSUtils;
import org.n52.io.geojson.old.GeojsonPoint;
import org.n52.io.request.FilterResolver;
import org.n52.io.request.Parameters;
import org.n52.io.request.RequestParameterSet;
import org.n52.io.request.RequestSimpleParameterSet;
import org.n52.io.request.RequestStyledParameterSet;
import org.n52.io.request.StyleProperties;
import org.n52.io.request.Vicinity;
import org.n52.io.response.BBox;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class IoParameters
implements Parameters {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoParameters.class);
    private static final String DEFAULT_CONFIG_FILE = "config-general.json";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final MultiValueMap<String, JsonNode> query;

    private IoParameters(File defaultConfig) {
        LinkedMultiValueMap config = new LinkedMultiValueMap();
        config.setAll(this.readDefaultConfig(defaultConfig));
        this.query = IoParameters.mergeToLowerCasedKeys((MultiValueMap<String, JsonNode>)config);
    }

    protected IoParameters(MultiValueMap<String, JsonNode> queryParameters, File defaults) {
        this(defaults);
        if (queryParameters != null) {
            this.query.putAll(IoParameters.mergeToLowerCasedKeys(queryParameters));
        }
    }

    protected IoParameters(MultiValueMap<String, JsonNode> queryParameters) {
        this(queryParameters, (File)null);
    }

    protected IoParameters(Map<String, JsonNode> queryParameters, File defaults) {
        this(defaults);
        this.query.setAll(IoParameters.mergeToLowerCasedKeys(queryParameters));
    }

    protected IoParameters(Map<String, JsonNode> queryParameters) {
        this(queryParameters, (File)null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, JsonNode> readDefaultConfig(File config) {
        try (InputStream stream = config == null ? IoParameters.getDefaultConfigFile() : new FileInputStream(config);){
            Map map = (Map)OBJECT_MAPPER.readValue(stream, (JavaType)TypeFactory.defaultInstance().constructMapLikeType(HashMap.class, String.class, JsonNode.class));
            return map;
        }
        catch (IOException e) {
            LOGGER.info("Could not load '{}'. Using empty config.", (Object)DEFAULT_CONFIG_FILE, (Object)e);
            return new HashMap<String, JsonNode>();
        }
    }

    private static InputStream getDefaultConfigFile() {
        try {
            Path path = Paths.get(IoParameters.class.getResource("/").toURI());
            File config = path.resolve(DEFAULT_CONFIG_FILE).toFile();
            String fallbackPath = "/config-general.json";
            return config.exists() ? new FileInputStream(config) : IoParameters.class.getClassLoader().getResourceAsStream("/config-general.json");
        }
        catch (IOException | URISyntaxException e) {
            LOGGER.debug("Could not find default config under '{}'", (Object)DEFAULT_CONFIG_FILE, (Object)e);
            return null;
        }
    }

    public int getOffset() {
        return this.getAsInteger("offset", -1);
    }

    public int getLimit() {
        return this.getAsInteger("limit", -1);
    }

    public int getWidth() {
        return this.getAsInteger("width", 800);
    }

    public int getHeight() {
        return this.getAsInteger("height", 500);
    }

    public boolean isBase64() {
        return this.getAsBoolean("base64", false);
    }

    public boolean isGrid() {
        return this.getAsBoolean("grid", true);
    }

    public boolean isGeneralize() throws IoParseException {
        return this.getAsBoolean("generalize", false);
    }

    public boolean isLegend() {
        return this.getAsBoolean("legend", false);
    }

    public String getLocale() {
        return this.getAsString("locale", "en");
    }

    public StyleProperties getStyle() {
        return this.containsParameter("style") ? this.parseStyleProperties(this.getAsString("style")) : StyleProperties.createDefaults();
    }

    private StyleProperties parseStyleProperties(String style) {
        try {
            return style == null ? StyleProperties.createDefaults() : (StyleProperties)new ObjectMapper().readValue(style, StyleProperties.class);
        }
        catch (JsonMappingException e) {
            throw new IoParseException("Could not read style properties: " + style, e);
        }
        catch (JsonParseException e) {
            throw new IoParseException("Could not parse style properties:" + style, e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("An error occured during request handling.", e);
        }
    }

    public String getFormat() {
        return this.getAsString("format", "tvp");
    }

    public boolean isSetRawFormat() {
        return this.containsParameter("rawFormat");
    }

    public String getRawFormat() {
        if (this.isSetRawFormat()) {
            JsonNode value = (JsonNode)this.query.getFirst((Object)"rawFormat");
            return value != null ? value.asText() : null;
        }
        return null;
    }

    public String getTimeFormat() {
        return this.getAsString("timeformat", "yyyy-MM-dd, HH:mm");
    }

    public IntervalWithTimeZone getTimespan() {
        return this.containsParameter("timespan") ? this.validateTimespan(this.getNormalizedTimespan()) : this.createDefaultTimespan();
    }

    private String getNormalizedTimespan() {
        return this.getNormalizedTimespan(null);
    }

    protected String getNormalizedTimespan(DateTimeFormatter dateFormat) {
        String parameterValue = this.getAsString("timespan");
        String now = dateFormat == null ? new DateTime().toString() : dateFormat.print((ReadableInstant)new DateTime());
        return parameterValue.replaceAll("(?i)now", now);
    }

    private IntervalWithTimeZone createDefaultTimespan() {
        DateTime now = new DateTime();
        DateTime lastWeek = now.minusWeeks(1);
        String interval = lastWeek.toString().concat("/").concat(now.toString());
        return new IntervalWithTimeZone(interval);
    }

    private IntervalWithTimeZone validateTimespan(String timespan) {
        return new IntervalWithTimeZone(timespan);
    }

    public String getOutputTimezone() {
        if (!this.containsParameter("outputTimezone")) {
            return "UTC";
        }
        return this.getAsString("outputTimezone");
    }

    public Instant getResultTime() {
        if (!this.containsParameter("resultTime")) {
            return null;
        }
        return this.validateTimestamp(this.getAsString("resultTime"));
    }

    private Instant validateTimestamp(String timestamp) {
        try {
            return Instant.parse((String)timestamp);
        }
        catch (Exception e) {
            String message = "Could not parse result time parameter." + timestamp;
            throw new IoParseException(message, e);
        }
    }

    @Deprecated
    public String getCategory() {
        return this.getAsString("category");
    }

    @Deprecated
    public String getService() {
        return this.getAsString("service");
    }

    @Deprecated
    public String getOffering() {
        return this.getAsString("offering");
    }

    @Deprecated
    public String getFeature() {
        return this.getAsString("feature");
    }

    @Deprecated
    public String getProcedure() {
        return this.getAsString("procedure");
    }

    @Deprecated
    public String getPhenomenon() {
        return this.getAsString("phenomenon");
    }

    @Deprecated
    public String getStation() {
        return this.getAsString("station");
    }

    public Set<String> getCategories() {
        Set<String> values = this.getValuesOf("categories");
        values.addAll(this.getValuesOf("category"));
        return values;
    }

    public Set<String> getServices() {
        Set<String> values = this.getValuesOf("services");
        values.addAll(this.getValuesOf("service"));
        return values;
    }

    public Set<String> getOfferings() {
        Set<String> values = this.getValuesOf("offerings");
        values.addAll(this.getValuesOf("offering"));
        return values;
    }

    public Set<String> getFeatures() {
        Set<String> values = this.getValuesOf("features");
        values.addAll(this.getValuesOf("feature"));
        return values;
    }

    public Set<String> getProcedures() {
        Set<String> values = this.getValuesOf("procedures");
        values.addAll(this.getValuesOf("procedure"));
        return values;
    }

    public Set<String> getPhenomena() {
        Set<String> values = this.getValuesOf("phenomena");
        values.addAll(this.getValuesOf("phenomenon"));
        return values;
    }

    public Set<String> getStations() {
        Set<String> values = this.getValuesOf("stations");
        values.addAll(this.getValuesOf("station"));
        return values;
    }

    public Set<String> getPlatforms() {
        return this.getValuesOf("platforms");
    }

    public Set<String> getTimeseries() {
        return this.getSeries();
    }

    public Set<String> getSeries() {
        Set<String> values = this.getValuesOf("series");
        values.addAll(this.getValuesOf("timeseries"));
        return values;
    }

    public Set<String> getDatasets() {
        return this.getValuesOf("datasets");
    }

    public Set<String> getFields() {
        return this.getValuesOf("fields");
    }

    public Set<String> getPlatformTypes() {
        return this.getValuesOf("platformTypes");
    }

    public Set<String> getPlatformGeometryTypes() {
        return this.getValuesOf("platformGeometries");
    }

    public Set<String> getObservedGeometryTypes() {
        return this.getValuesOf("observedGeometries");
    }

    public Set<String> getValueTypes() {
        return this.getValuesOf("valueTypes");
    }

    public Set<String> getSearchTerms() {
        return this.getValuesOf("q");
    }

    public Set<String> getGeometryTypes() {
        return this.getValuesOf("geometryTypes");
    }

    Set<String> getValuesOf(String parameterName) {
        return this.containsParameter(parameterName) ? new HashSet<String>(this.csvToLowerCasedSet(this.getAsString(parameterName))) : Collections.emptySet();
    }

    private Set<String> csvToLowerCasedSet(String csv) {
        String[] values = csv.split(",");
        for (int i = 0; i < values.length; ++i) {
            values[i] = values[i].toLowerCase();
        }
        return new HashSet<String>(Arrays.asList(values));
    }

    public FilterResolver getFilterResolver() {
        return new FilterResolver(this);
    }

    public BoundingBox getSpatialFilter() {
        if (!this.containsParameter("near") && !this.containsParameter("bbox")) {
            return null;
        }
        BBox bboxBounds = this.createBbox();
        BoundingBox bounds = this.parseBoundsFromVicinity();
        return this.mergeBounds(bounds, bboxBounds);
    }

    private BoundingBox mergeBounds(BoundingBox bounds, BBox bboxBounds) {
        if (bboxBounds == null) {
            return bounds;
        }
        CRSUtils crsUtils = CRSUtils.createEpsgForcedXYAxisOrder();
        Point lowerLeft = crsUtils.convertToPointFrom(bboxBounds.getLl());
        Point upperRight = crsUtils.convertToPointFrom(bboxBounds.getUr());
        if (bounds == null) {
            BoundingBox parsed = new BoundingBox(lowerLeft, upperRight, "CRS:84");
            LOGGER.debug("Parsed bbox bounds: {}", (Object)parsed.toString());
            return parsed;
        }
        this.extendBy(lowerLeft, bounds);
        this.extendBy(upperRight, bounds);
        LOGGER.debug("Merged bounds: {}", (Object)bounds.toString());
        return bounds;
    }

    private void extendBy(Point point, BoundingBox bbox) {
        if (bbox.contains(point)) {
            return;
        }
        double llX = Math.min(point.getX(), bbox.getLowerLeft().getX());
        double llY = Math.max(point.getX(), bbox.getUpperRight().getX());
        double urX = Math.min(point.getY(), bbox.getLowerLeft().getY());
        double urY = Math.max(point.getY(), bbox.getUpperRight().getY());
        CRSUtils crsUtils = CRSUtils.createEpsgForcedXYAxisOrder();
        bbox.setLl(crsUtils.createPoint(llX, llY, bbox.getSrs()));
        bbox.setUr(crsUtils.createPoint(urX, urY, bbox.getSrs()));
    }

    private BBox createBbox() {
        if (!this.containsParameter("bbox")) {
            return null;
        }
        String bboxValue = this.getAsString("bbox");
        BBox bbox = this.parseJson(bboxValue, BBox.class);
        bbox.setLl(this.convertToCrs84(bbox.getLl()));
        bbox.setUr(this.convertToCrs84(bbox.getUr()));
        return bbox;
    }

    private BoundingBox parseBoundsFromVicinity() {
        if (!this.containsParameter("near")) {
            return null;
        }
        String vicinityValue = this.getAsString("near");
        Vicinity vicinity = this.parseJson(vicinityValue, Vicinity.class);
        if (this.containsParameter("crs")) {
            vicinity.setCenter(this.convertToCrs84(vicinity.getCenter()));
        }
        BoundingBox bounds = vicinity.calculateBounds();
        LOGGER.debug("Parsed vicinity bounds: {}", (Object)bounds.toString());
        return bounds;
    }

    private <T> T parseJson(String jsonString, Class<T> clazz) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (T)mapper.readValue(jsonString, clazz);
        }
        catch (JsonParseException e) {
            throw new IoParseException("The given parameter is invalid JSON." + jsonString, e);
        }
        catch (JsonMappingException e) {
            throw new IoParseException("The given parameter could not been read: " + jsonString, e);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not handle input to parse.", e);
        }
    }

    private GeojsonPoint convertToCrs84(GeojsonPoint point) {
        return this.isForceXY() ? this.transformToInnerCrs(point, CRSUtils.createEpsgForcedXYAxisOrder()) : this.transformToInnerCrs(point, CRSUtils.createEpsgStrictAxisOrder());
    }

    private GeojsonPoint transformToInnerCrs(GeojsonPoint point, CRSUtils crsUtils) {
        try {
            Point toTransformed = crsUtils.convertToPointFrom(point, this.getCrs());
            Point crs84Point = (Point)crsUtils.transformOuterToInner((Geometry)toTransformed, this.getCrs());
            return crsUtils.convertToGeojsonFrom(crs84Point);
        }
        catch (TransformException e) {
            throw new IoParseException("Could not transform to internally used CRS:84.", e);
        }
        catch (FactoryException e) {
            throw new IoParseException("Check if 'crs' parameter is a valid EPSG CRS. Was: '" + this.getCrs() + "'.", e);
        }
    }

    public String getCrs() {
        return this.getAsString("crs", "CRS:84");
    }

    public boolean isForceXY() {
        return this.getAsBoolean("forceXY", false);
    }

    public boolean isMatchDomainIds() {
        return this.getAsBoolean("matchDomainIds", false);
    }

    public boolean isExpanded() {
        return this.getAsBoolean("expanded", false);
    }

    public boolean isForceLatestValueRequests() {
        return this.getAsBoolean("force_latest_values", false);
    }

    @Deprecated
    public boolean isStatusIntervalsRequests() {
        return this.getAsBoolean("status_intervals", false);
    }

    @Deprecated
    public boolean isRenderingHintsRequests() {
        return this.getAsBoolean("rendering_hints", false);
    }

    public String getHrefBase() {
        return this.getAsString("internal.href.base");
    }

    public boolean isShowTimeIntervals() {
        return this.getAsBoolean("showTimeIntervals", false);
    }

    public boolean containsParameter(String parameter) {
        return this.query.containsKey((Object)parameter.toLowerCase()) || this.query.containsKey((Object)parameter);
    }

    public String getOther(String parameter) {
        return this.getAsString(parameter);
    }

    public String getAsString(String parameter, String defaultValue) {
        return this.containsParameter(parameter) ? this.getAsString(parameter) : defaultValue;
    }

    public String getAsString(String parameter) {
        if (!this.containsParameter(parameter)) {
            return null;
        }
        List value = this.query.get((Object)parameter) == null ? (List)this.query.get((Object)parameter.toLowerCase()) : (List)this.query.get((Object)parameter);
        return this.asCsv(value);
    }

    private String asCsv(List<JsonNode> list) {
        StringBuilder sb = new StringBuilder();
        for (JsonNode jsonNode : list) {
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(jsonNode.asText());
        }
        return sb.toString();
    }

    public int getAsInteger(String parameter, int defaultValue) {
        return this.containsParameter(parameter) ? this.getAsInteger(parameter) : defaultValue;
    }

    public int getAsInteger(String parameter) {
        try {
            String value = this.getAsString(parameter);
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            this.throwIoParseException(parameter, "Must be an integer!", e);
            return -1;
        }
    }

    public boolean getAsBoolean(String parameter, boolean defaultValue) {
        return this.containsParameter(parameter) ? this.getAsBoolean(parameter) : defaultValue;
    }

    public boolean getAsBoolean(String parameter) {
        try {
            String value = this.getAsString(parameter);
            return Boolean.parseBoolean(value);
        }
        catch (NumberFormatException e) {
            this.throwIoParseException(parameter, "Must be 'false' or 'true'!", e);
            return false;
        }
    }

    private void throwIoParseException(String parameter, String expected, Exception e) throws IoParseException {
        String msg = "Parameter '" + parameter + "'. ";
        throw new IoParseException(msg + expected, e);
    }

    public RequestSimpleParameterSet toSimpleParameterSet() {
        RequestSimpleParameterSet parameterSet = new RequestSimpleParameterSet();
        this.addValuesToParameterSet(parameterSet);
        return parameterSet;
    }

    public RequestSimpleParameterSet mergeToSimpleParameterSet(RequestStyledParameterSet designedSet) {
        RequestSimpleParameterSet parameters = this.toSimpleParameterSet();
        parameters.setOutputTimezone(designedSet.getOutputTimezone());
        parameters.setDatasets(designedSet.getDatasets());
        parameters.setTimespan(designedSet.getTimespan());
        return parameters;
    }

    public RequestStyledParameterSet toStyledParameterSet() {
        return this.mergeToStyledParameterSet(new RequestStyledParameterSet());
    }

    public RequestStyledParameterSet mergeToStyledParameterSet(RequestStyledParameterSet parameterSet) {
        this.addValuesToParameterSet(parameterSet);
        return parameterSet;
    }

    private RequestParameterSet addValuesToParameterSet(RequestParameterSet parameterSet) {
        for (Map.Entry entry : this.query.entrySet()) {
            List values = (List)entry.getValue();
            String lowercasedKey = ((String)entry.getKey()).toLowerCase();
            if (values.size() == 1) {
                parameterSet.setParameter(lowercasedKey, (JsonNode)values.get(0));
                continue;
            }
            parameterSet.setParameter(lowercasedKey, IoParameters.getJsonNodeFrom(values));
        }
        return parameterSet;
    }

    public static JsonNode getJsonNodeFrom(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return OBJECT_MAPPER.readTree(OBJECT_MAPPER.writeValueAsString(object));
        }
        catch (IOException e) {
            LOGGER.error("Could not parse parameter", (Throwable)e);
            return null;
        }
    }

    public IoParameters removeAllOf(String key) {
        LinkedMultiValueMap newValues = new LinkedMultiValueMap(this.query);
        newValues.remove((Object)key.toLowerCase());
        return new IoParameters((MultiValueMap<String, JsonNode>)newValues);
    }

    public IoParameters extendWith(String key, String ... values) {
        LinkedMultiValueMap newValues = new LinkedMultiValueMap();
        newValues.put((Object)key.toLowerCase(), Arrays.asList(values));
        LinkedMultiValueMap mergedValues = new LinkedMultiValueMap(this.query);
        mergedValues.putAll(IoParameters.convertValuesToJsonNodes((MultiValueMap<String, String>)newValues));
        return new IoParameters((MultiValueMap<String, JsonNode>)mergedValues);
    }

    protected static Map<String, JsonNode> convertValuesToJsonNodes(Map<String, String> queryParameters) {
        HashMap<String, JsonNode> parameters = new HashMap<String, JsonNode>();
        for (Map.Entry<String, String> entry : queryParameters.entrySet()) {
            String key = entry.getKey().toLowerCase();
            parameters.put(key, IoParameters.getJsonNodeFrom(entry.getValue()));
        }
        return parameters;
    }

    protected static MultiValueMap<String, JsonNode> convertValuesToJsonNodes(MultiValueMap<String, String> queryParameters) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        Set entrySet = queryParameters.entrySet();
        for (Map.Entry entry : entrySet) {
            for (String value : (List)entry.getValue()) {
                String key = ((String)entry.getKey()).toLowerCase();
                parameters.add((Object)key, (Object)IoParameters.getJsonNodeFrom(value));
            }
        }
        return parameters;
    }

    public String toString() {
        return "IoParameters{query=" + this.query + '}';
    }

    private static Map<String, JsonNode> mergeToLowerCasedKeys(Map<String, JsonNode> parameters) {
        HashMap<String, JsonNode> queryParameters = new HashMap<String, JsonNode>();
        for (Map.Entry<String, JsonNode> entry : parameters.entrySet()) {
            String parameter = entry.getKey();
            String lowerCasedKey = parameter.toLowerCase();
            queryParameters.put(lowerCasedKey, parameters.get(parameter));
        }
        return queryParameters;
    }

    private static MultiValueMap<String, JsonNode> mergeToLowerCasedKeys(MultiValueMap<String, JsonNode> parameters) {
        LinkedMultiValueMap queryParameters = new LinkedMultiValueMap();
        for (Map.Entry entry : parameters.entrySet()) {
            String parameter = (String)entry.getKey();
            String lowerCasedKey = parameter.toLowerCase();
            List values = (List)parameters.get((Object)parameter);
            if (!queryParameters.containsKey((Object)lowerCasedKey)) {
                queryParameters.put((Object)lowerCasedKey, (Object)values);
                continue;
            }
            ((List)queryParameters.get((Object)lowerCasedKey)).addAll(values);
        }
        return queryParameters;
    }

    public static IoParameters createDefaults() {
        return IoParameters.createDefaults(null);
    }

    static IoParameters createDefaults(File defaultConfig) {
        return new IoParameters(Collections.emptyMap(), defaultConfig);
    }

    static IoParameters createFromMultiValueMap(MultiValueMap<String, String> query) {
        return IoParameters.createFromMultiValueMap(query, null);
    }

    static IoParameters createFromMultiValueMap(MultiValueMap<String, String> query, File defaultConfig) {
        return new IoParameters(IoParameters.convertValuesToJsonNodes(query), defaultConfig);
    }

    static IoParameters createFromSingleValueMap(Map<String, String> query) {
        return IoParameters.createFromSingleValueMap(query, null);
    }

    static IoParameters createFromSingleValueMap(Map<String, String> query, File defaultConfig) {
        return new IoParameters(IoParameters.convertValuesToJsonNodes(query), defaultConfig);
    }

    public static IoParameters createFromQuery(RequestParameterSet parameters) {
        return IoParameters.createFromQuery(parameters, null);
    }

    public static IoParameters createFromQuery(RequestParameterSet parameters, File defaultConfig) {
        HashMap<String, JsonNode> queryParameters = new HashMap<String, JsonNode>();
        for (String parameter : parameters.availableParameterNames()) {
            JsonNode value = parameters.getParameterValue(parameter);
            queryParameters.put(parameter.toLowerCase(), value);
        }
        return new IoParameters(queryParameters, defaultConfig);
    }

    public static IoParameters ensureBackwardsCompatibility(IoParameters parameters) {
        String[] platformTypes = new String[]{"stationary", "insitu"};
        return IoParameters.isBackwardsCompatibilityRequest(parameters) ? parameters.extendWith("platformTypes", platformTypes).extendWith("valueTypes", "quantity").removeAllOf("internal.href.base") : parameters;
    }

    private static boolean isBackwardsCompatibilityRequest(IoParameters parameters) {
        return !parameters.containsParameter("platformTypes") && !parameters.containsParameter("valueTypes");
    }

    public boolean isPureStationaryInsituQuery() {
        Set<String> platformTypes = this.getPlatformTypes();
        Set<String> datasetTypes = this.getValueTypes();
        return this.isStationaryInsituOnly(platformTypes) && this.isQuantityOnly(datasetTypes);
    }

    private boolean isStationaryInsituOnly(Set<String> platformTypes) {
        return platformTypes.size() == 2 && platformTypes.contains("stationary") && platformTypes.contains("insitu");
    }

    private boolean isQuantityOnly(Set<String> valueTypes) {
        return valueTypes.size() == 1 && valueTypes.contains("quantity");
    }
}

