/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.response;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.vividsolutions.jts.geom.Geometry;
import java.util.HashMap;
import java.util.Map;
import org.n52.io.geojson.FeatureOutputSerializer;
import org.n52.io.geojson.GeoJSONFeature;
import org.n52.io.geojson.GeoJSONObject;
import org.n52.io.response.AbstractOutput;
import org.n52.io.response.GeometryType;
import org.n52.io.response.PlatformOutput;
import org.n52.io.response.ServiceOutput;

@JsonSerialize(using=FeatureOutputSerializer.class, as=GeoJSONObject.class)
public class GeometryInfo
extends AbstractOutput
implements GeoJSONFeature {
    private Geometry geometry;
    private PlatformOutput platform;
    private final GeometryType geometyCategory;

    public GeometryInfo(GeometryType category) {
        this.geometyCategory = category;
    }

    @Override
    public void setId(String id) {
        super.setId(this.geometyCategory.createId(id));
    }

    @Override
    public String getLabel() {
        return super.getLabel();
    }

    @Override
    public String getDomainId() {
        return super.getDomainId();
    }

    @Override
    public ServiceOutput getService() {
        return super.getService();
    }

    public PlatformOutput getPlatform() {
        return this.platform;
    }

    public void setPlatform(PlatformOutput platform) {
        this.platform = platform;
    }

    @Override
    public Geometry getGeometry() {
        return this.geometry;
    }

    @Override
    public void setGeometry(Geometry geometry) {
        this.geometry = geometry;
    }

    @Override
    public String getHrefBase() {
        String base = super.getHrefBase();
        String suffix = this.getUrlIdPrefix();
        return base != null && base.endsWith(suffix) ? base.substring(0, base.lastIndexOf(suffix) - 1) : base;
    }

    private String getUrlIdPrefix() {
        return this.getType().getGeometryType();
    }

    public GeometryType getType() {
        return this.geometyCategory;
    }

    public String getGeometyCategory() {
        return this.geometyCategory.getGeometryType();
    }

    @Override
    public Map<String, Object> getProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("geometryType", this.getGeometyCategory());
        properties.put("platform", this.platform);
        properties.put("href", this.getHref());
        properties.put("id", this.getId());
        return properties;
    }

    @Override
    public boolean isSetGeometry() {
        return this.getGeometry() != null && !this.getGeometry().isEmpty();
    }
}

