/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.response;

import java.util.Locale;

public enum GeometryType {
    PLATFORM_SITE,
    PLATFORM_TRACK,
    OBSERVED_STATIC,
    OBSERVED_DYNAMIC;

    private static final String SEPARATOR = "_";

    public String createId(String id) {
        return this.getGeometryType() + SEPARATOR + id;
    }

    public String getGeometryType() {
        return this.name().toLowerCase();
    }

    public static boolean isPlatformGeometryId(String id) {
        return GeometryType.startsWith("platform", id);
    }

    public static boolean isObservedGeometryId(String id) {
        return GeometryType.startsWith("observed", id);
    }

    private static boolean startsWith(String prefix, String id) {
        String idPrefix = GeometryType.extractPrefix(id);
        if (!GeometryType.isKnownType(idPrefix)) {
            return false;
        }
        return id.toLowerCase().startsWith(prefix);
    }

    public static boolean isSiteId(String id) {
        return GeometryType.hasSuffix("site", id);
    }

    public static boolean isTrackId(String id) {
        return GeometryType.hasSuffix("track", id);
    }

    public static boolean isStaticId(String id) {
        return GeometryType.hasSuffix("static", id);
    }

    public static boolean isDynamicId(String id) {
        return GeometryType.hasSuffix("dynamic", id);
    }

    private static boolean hasSuffix(String suffix, String id) {
        String idPrefix = GeometryType.extractPrefix(id);
        if (!GeometryType.isKnownType(idPrefix)) {
            return false;
        }
        GeometryType geometryType = GeometryType.toInstance(idPrefix);
        return geometryType.getGeometryType().endsWith(suffix);
    }

    public static boolean isKnownType(String typeName) {
        for (GeometryType type : GeometryType.values()) {
            if (!type.getGeometryType().equalsIgnoreCase(typeName)) continue;
            return true;
        }
        return false;
    }

    public static String extractId(String id) {
        String replacedId = id;
        for (GeometryType geometryType : GeometryType.values()) {
            replacedId = replacedId.replaceAll(geometryType.getGeometryType() + SEPARATOR, "");
        }
        return replacedId;
    }

    private static String extractPrefix(String id) {
        for (GeometryType geometryType : GeometryType.values()) {
            String prefix = geometryType.getGeometryType();
            if (id == null || !id.toLowerCase().startsWith(prefix)) continue;
            return prefix;
        }
        return id;
    }

    public static GeometryType toInstance(String id) {
        for (GeometryType geometryType : GeometryType.values()) {
            if (!geometryType.name().toLowerCase(Locale.ROOT).startsWith(id)) continue;
            return geometryType;
        }
        throw new IllegalArgumentException("no type for '" + id + "'.");
    }
}

