/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.n52.io.response.CollatorComparable;

public abstract class OutputCollection<T>
implements Iterable<T> {
    private final List<T> items;

    protected OutputCollection() {
        this.items = new ArrayList<T>();
    }

    protected OutputCollection(T item) {
        this();
        if (item != null) {
            this.addItem(item);
        }
    }

    protected OutputCollection(Collection<T> items) {
        this.items = items == null ? new ArrayList<T>() : new ArrayList<T>(items);
    }

    protected OutputCollection(T ... items) {
        this.items = items == null ? new ArrayList() : Arrays.asList(items);
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public final void addItem(T item) {
        this.items.add(item);
    }

    public final void addItems(Collection<T> toAdd) {
        this.items.addAll(toAdd);
    }

    public void removeItem(T item) {
        this.items.remove(item);
    }

    public T getItem(int i) {
        return this.items.get(i);
    }

    public List<T> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public int size() {
        return this.items.size();
    }

    public OutputCollection<T> withSortedItems() {
        Collections.sort(this.items, this.getComparator());
        return this;
    }

    public OutputCollection<T> withSortedItems(Collator collator) {
        return collator != null && this.isCollatorComparable() ? this.collatorSort(collator) : this.withSortedItems();
    }

    private OutputCollection<T> collatorSort(Collator collator) {
        for (int i = 0; i < this.items.size(); ++i) {
            for (int j = i + 1; j < this.items.size(); ++j) {
                CollatorComparable first = (CollatorComparable)((Object)this.items);
                T second = this.items.get(j);
                if (first.compare(collator, second) <= 0) continue;
                this.swap(i, j);
            }
        }
        return this;
    }

    private boolean isCollatorComparable() {
        return CollatorComparable.class.isAssignableFrom(this.items.getClass());
    }

    private void swap(int i, int j) {
        T tmp = this.items.get(i);
        this.items.add(i, this.items.get(j));
        this.items.add(j, tmp);
    }

    protected abstract Comparator<T> getComparator();

    public boolean containsItem(T item) {
        return this.items.contains(item);
    }

    @Override
    public Iterator<T> iterator() {
        return this.items.iterator();
    }
}

