/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.vividsolutions.jts.geom.Geometry;
import java.util.Collection;
import java.util.List;
import org.n52.io.geojson.GeoJSONGeometrySerializer;
import org.n52.io.response.OutputWithParameters;
import org.n52.io.response.PlatformType;
import org.n52.io.response.dataset.DatasetOutput;

public class PlatformOutput
extends OutputWithParameters {
    private final PlatformType platformType;
    private Collection<DatasetOutput> datasets;
    private Geometry geometry;

    public PlatformOutput(PlatformType platformType) {
        this.platformType = platformType;
    }

    @Override
    public String getHrefBase() {
        String base = super.getHrefBase();
        String suffix = this.getType().getPlatformType();
        return base != null && base.endsWith(suffix) ? base.substring(0, base.lastIndexOf(suffix) - 1) : base;
    }

    public String getPlatformType() {
        return this.getType().getPlatformType();
    }

    @JsonIgnore
    public PlatformType getType() {
        return this.platformType != null ? this.platformType : PlatformType.STATIONARY_INSITU;
    }

    @Override
    public void setId(String id) {
        super.setId(this.getType().createId(id));
    }

    public Collection<DatasetOutput> getDatasets() {
        return this.datasets;
    }

    public void setDatasets(List<DatasetOutput> series) {
        this.datasets = series;
    }

    @JsonSerialize(using=GeoJSONGeometrySerializer.class)
    public Geometry getGeometry() {
        return this.geometry;
    }

    public void setGeometry(Geometry geometry) {
        this.geometry = geometry;
    }
}

