/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.response;

public enum PlatformType {
    STATIONARY_INSITU,
    STATIONARY_REMOTE,
    MOBILE_INSITU,
    MOBILE_REMOTE;

    public static final String PLATFORM_TYPE_MOBILE = "mobile";
    public static final String PLATFORM_TYPE_STATIONARY = "stationary";
    public static final String PLATFORM_TYPE_INSITU = "insitu";
    public static final String PLATFORM_TYPE_REMOTE = "remote";
    public static final String PLATFORM_TYPE_ALL = "all";

    public String getPlatformType() {
        return this.name().toLowerCase();
    }

    private String getIdPrefix() {
        return this.name().toLowerCase();
    }

    public String createId(Long id) {
        return this.getIdPrefix() + "_" + Long.toString(id);
    }

    public String createId(String id) {
        return this.getIdPrefix() + "_" + id;
    }

    public boolean isStationary() {
        return this == STATIONARY_INSITU || this == STATIONARY_REMOTE;
    }

    public boolean isMobile() {
        return this == MOBILE_INSITU || this == MOBILE_REMOTE;
    }

    public static String extractId(String id) {
        if (PlatformType.isStationaryId(id)) {
            return PlatformType.isInsitu(id) ? PlatformType.extractId(STATIONARY_INSITU, id) : PlatformType.extractId(STATIONARY_REMOTE, id);
        }
        if (PlatformType.isMobileId(id)) {
            return PlatformType.isInsitu(id) ? PlatformType.extractId(MOBILE_INSITU, id) : PlatformType.extractId(MOBILE_REMOTE, id);
        }
        return id;
    }

    private static String extractId(PlatformType type, String id) {
        int maxLength = type.getIdPrefix().length() + 1;
        return id.length() >= maxLength ? id.substring(maxLength) : id;
    }

    public static boolean isStationaryId(String id) {
        return PlatformType.startsWith(PLATFORM_TYPE_STATIONARY, id);
    }

    public static boolean isMobileId(String id) {
        return PlatformType.startsWith(PLATFORM_TYPE_MOBILE, id);
    }

    private static boolean startsWith(String prefix, String id) {
        String idPrefix = PlatformType.extractPrefix(id);
        if (!PlatformType.isKnownType(idPrefix)) {
            return false;
        }
        return id.toLowerCase().startsWith(prefix);
    }

    public static boolean isRemoteId(String id) {
        return PlatformType.hasSuffix(PLATFORM_TYPE_REMOTE, id);
    }

    public static boolean isInsitu(String id) {
        return PlatformType.hasSuffix(PLATFORM_TYPE_INSITU, id);
    }

    private static boolean hasSuffix(String suffix, String id) {
        String idPrefix = PlatformType.extractPrefix(id);
        if (!PlatformType.isKnownType(idPrefix)) {
            return false;
        }
        PlatformType geometryType = PlatformType.toInstance(idPrefix);
        return geometryType.getPlatformType().endsWith(suffix);
    }

    public static boolean isKnownType(String typeName) {
        for (PlatformType type : PlatformType.values()) {
            if (!type.getPlatformType().equalsIgnoreCase(typeName)) continue;
            return true;
        }
        return false;
    }

    private static String extractPrefix(String id) {
        for (PlatformType type : PlatformType.values()) {
            String prefix = type.getPlatformType();
            if (id == null || !id.toLowerCase().startsWith(prefix)) continue;
            return prefix;
        }
        return id;
    }

    public static PlatformType toInstance(String typeName) {
        for (PlatformType type : PlatformType.values()) {
            if (type.getIdPrefix().equalsIgnoreCase(typeName)) {
                return type;
            }
            if (!type.getPlatformType().equalsIgnoreCase(typeName)) continue;
            return type;
        }
        throw new IllegalArgumentException("no type for '" + typeName + "'.");
    }

    public static PlatformType toInstance(boolean mobile, boolean insitu) {
        if (mobile) {
            return insitu ? MOBILE_INSITU : MOBILE_REMOTE;
        }
        return insitu ? STATIONARY_INSITU : STATIONARY_REMOTE;
    }
}

