/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.response;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.n52.io.MimeType;
import org.n52.io.Utils;
import org.n52.io.response.ParameterOutput;

public class ServiceOutput
extends ParameterOutput {
    private String serviceUrl;
    private String version;
    private String type;
    private Map<String, Object> features;
    private ParameterCount quantities;
    @Deprecated
    private Boolean supportsFirstLatest;

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void addSupportedDatasets(Map<String, Set<String>> mimeTypesByDatasetTypes) {
        for (Set<String> supportedMimeTypes : mimeTypesByDatasetTypes.values()) {
            supportedMimeTypes.add(MimeType.APPLICATION_JSON.getMimeType());
        }
        this.addFeature("supportedMimeTypes", mimeTypesByDatasetTypes);
    }

    @JsonAnyGetter
    public Map<String, Object> getFeatures() {
        return this.features != null ? Collections.unmodifiableMap(this.features) : null;
    }

    public void setFeatures(Map<String, Object> features) {
        this.features = features;
    }

    public void addFeature(String featureName, Object featureInfo) {
        if (this.features == null) {
            this.features = new HashMap<String, Object>();
        }
        this.features.put(featureName, featureInfo);
    }

    @JsonIgnore
    @Deprecated
    public Boolean isSupportsFirstLatest() {
        return this.supportsFirstLatest;
    }

    public void setSupportsFirstLatest(Boolean supportsFirstLatest) {
        this.addFeature("supportsFirstLatest", supportsFirstLatest);
        this.supportsFirstLatest = supportsFirstLatest;
    }

    @JsonIgnore
    public ParameterCount getQuantities() {
        return this.quantities;
    }

    public void setQuantities(ParameterCount countedParameters) {
        this.addFeature("quantities", countedParameters);
        this.quantities = countedParameters;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.serviceUrl == null ? 0 : this.serviceUrl.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ServiceOutput)) {
            return false;
        }
        ServiceOutput other = (ServiceOutput)obj;
        if (this.serviceUrl == null ? other.serviceUrl != null : !this.serviceUrl.equals(other.serviceUrl)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public static class ParameterCount {
        private String[] selectedPlatformTypes;
        private Integer amountOfferings;
        private Integer amountFeatures;
        private Integer amountProcedures;
        private Integer amountPhenomena;
        private Integer amountCategories;
        private Integer amountPlatforms;
        private Integer amountDatasets;
        @Deprecated
        private Integer amountStations;
        @Deprecated
        private Integer amountTimeseries;

        public String[] getSelectedPlatformTypes() {
            return Utils.copy(this.selectedPlatformTypes);
        }

        public void setSelectedPlatformTypes(String ... selectedPlatformTypes) {
            this.selectedPlatformTypes = selectedPlatformTypes;
        }

        public Integer getOfferings() {
            return this.amountOfferings;
        }

        public void setOfferingsSize(Integer size) {
            this.amountOfferings = size;
        }

        public Integer getFeatures() {
            return this.amountFeatures;
        }

        public void setFeaturesSize(Integer size) {
            this.amountFeatures = size;
        }

        public Integer getProcedures() {
            return this.amountProcedures;
        }

        public void setProceduresSize(Integer size) {
            this.amountProcedures = size;
        }

        public Integer getPhenomena() {
            return this.amountPhenomena;
        }

        public void setPhenomenaSize(Integer size) {
            this.amountPhenomena = size;
        }

        public Integer getCategories() {
            return this.amountCategories;
        }

        public void setCategoriesSize(Integer size) {
            this.amountCategories = size;
        }

        public Integer getPlatforms() {
            return this.amountPlatforms;
        }

        public void setPlatformsSize(Integer size) {
            this.amountPlatforms = size;
        }

        public Integer getDatasets() {
            return this.amountDatasets;
        }

        public void setDatasetsSize(Integer size) {
            this.amountDatasets = size;
        }

        @Deprecated
        public Integer getStations() {
            return this.amountStations;
        }

        @Deprecated
        public void setStationsSize(int size) {
            this.amountStations = size;
        }

        @Deprecated
        public void setTimeseriesSize(int countTimeseries) {
            this.amountTimeseries = countTimeseries;
        }

        @Deprecated
        public Integer getTimeseries() {
            return this.amountTimeseries;
        }
    }
}

