/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.response.dataset;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.vividsolutions.jts.geom.Geometry;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.n52.io.geojson.GeoJSONGeometrySerializer;

public abstract class AbstractValue<T>
implements Comparable<AbstractValue<?>>,
Serializable {
    private static final long serialVersionUID = -1606015864495830281L;
    private Long timestart;
    private Long timestamp;
    private T value;
    private Geometry geometry;
    private Set<Map<String, Object>> parameters;
    private ValidTime validTime;

    public AbstractValue() {
    }

    public AbstractValue(Long timestamp, T value) {
        this(null, timestamp, value);
    }

    public AbstractValue(Long timestart, Long timeend, T value) {
        this.timestart = timestart;
        this.timestamp = timeend;
        this.value = value;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public Long getTimestart() {
        return this.timestart;
    }

    public void setTimestart(Long timestart) {
        this.timestart = timestart;
    }

    @JsonIgnore
    public boolean isNoDataValue() {
        return this.value == null;
    }

    @JsonInclude(content=JsonInclude.Include.ALWAYS)
    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    @JsonSerialize(using=GeoJSONGeometrySerializer.class)
    public Geometry getGeometry() {
        return this.geometry;
    }

    public void setGeometry(Geometry geometry) {
        this.geometry = geometry;
    }

    @JsonIgnore
    public boolean isSetGeometry() {
        return this.geometry != null && !this.geometry.isEmpty();
    }

    public void setParameters(Set<Map<String, Object>> parameters) {
        this.parameters = new HashSet<Map<String, Object>>(parameters);
    }

    public Set<Map<String, Object>> getParameters() {
        return this.parameters != null ? Collections.unmodifiableSet(this.parameters) : null;
    }

    public void addParameter(Map<String, Object> parameterValue) {
        if (this.parameters == null) {
            this.parameters = new HashSet<Map<String, Object>>();
        }
        this.parameters.add(parameterValue);
    }

    public ValidTime getValidTime() {
        return this.validTime;
    }

    public void setValidTime(ValidTime validTime) {
        this.validTime = validTime;
    }

    @Override
    public int compareTo(AbstractValue<?> o) {
        return this.getTimestamp().compareTo(o.getTimestamp());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append(" [ ");
        sb.append("timestart: ").append(this.getTimestart()).append(", ");
        sb.append("timestamp: ").append(this.getTimestamp()).append(", ");
        sb.append("value: ").append(this.getValue());
        return sb.append(" ]").toString();
    }

    public static class ValidTime {
        private Long start;
        private Long end;

        public ValidTime(Long start, Long end) {
            this.start = start;
            this.end = end;
        }

        public Long getStart() {
            return this.start;
        }

        public void setStart(Long start) {
            this.start = start;
        }

        public Long getEnd() {
            return this.end;
        }

        public void setEnd(Long end) {
            this.end = end;
        }
    }
}

