/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.response.dataset;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.n52.io.Utils;
import org.n52.io.response.ParameterOutput;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.ReferenceValueOutput;
import org.n52.io.response.dataset.SeriesParameters;
import org.n52.io.response.dataset.ValueType;

public abstract class DatasetOutput<V extends AbstractValue<?>, R extends ReferenceValueOutput<?>>
extends ParameterOutput {
    private final String valueType;
    private String platformType;
    private SeriesParameters seriesParameters;
    private Set<String> rawFormats;
    private R[] referenceValues;
    private V firstValue;
    private V lastValue;
    private String uom;

    public DatasetOutput(String valueType) {
        this.valueType = valueType;
    }

    @Override
    public void setId(String id) {
        super.setId(ValueType.createId(this.valueType, id));
    }

    public String getValueType() {
        return this.valueType;
    }

    public String getPlatformType() {
        return this.platformType;
    }

    public void setPlatformType(String platformType) {
        this.platformType = platformType;
    }

    public SeriesParameters getSeriesParameters() {
        return this.seriesParameters;
    }

    public void setSeriesParameters(SeriesParameters parameters) {
        this.seriesParameters = parameters;
    }

    public String getUom() {
        return this.uom;
    }

    public void setUom(String uom) {
        this.uom = uom;
    }

    @Override
    public String[] getRawFormats() {
        if (this.rawFormats != null) {
            return this.rawFormats.toArray(new String[0]);
        }
        return null;
    }

    @Override
    public void addRawFormat(String format) {
        if (format != null && !format.isEmpty()) {
            if (this.rawFormats == null) {
                this.rawFormats = new HashSet<String>();
            }
            this.rawFormats.add(format);
        }
    }

    @Override
    public void setRawFormats(Collection<String> formats) {
        if (formats != null && !formats.isEmpty()) {
            if (this.rawFormats == null) {
                this.rawFormats = new HashSet<String>();
            } else {
                this.rawFormats.clear();
            }
            this.rawFormats.addAll(formats);
        }
    }

    public V getFirstValue() {
        return this.firstValue;
    }

    public void setFirstValue(V firstValue) {
        this.firstValue = firstValue;
    }

    public V getLastValue() {
        return this.lastValue;
    }

    public void setLastValue(V lastValue) {
        this.lastValue = lastValue;
    }

    public R[] getReferenceValues() {
        return (ReferenceValueOutput[])Utils.copy(this.referenceValues);
    }

    public void setReferenceValues(R[] referenceValues) {
        this.referenceValues = (ReferenceValueOutput[])Utils.copy(referenceValues);
    }
}

