/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.response.dataset;

public class ValueType {
    public static final String DEFAULT_VALUE_TYPE = "quantity";
    private static final String SEPERATOR = "_";

    public static String extractType(String id) {
        return ValueType.extractType(id, null);
    }

    public static String extractType(String id, String defaultValue) {
        String fallback;
        String string = fallback = defaultValue == null || defaultValue.isEmpty() ? DEFAULT_VALUE_TYPE : defaultValue;
        if (id == null || id.isEmpty()) {
            return fallback;
        }
        int separatorIndex = id.indexOf(SEPERATOR);
        return separatorIndex >= 0 ? id.substring(0, separatorIndex) : fallback;
    }

    public static String extractId(String id) {
        if (id == null || id.isEmpty()) {
            return id;
        }
        return id.substring(id.indexOf(SEPERATOR) + 1);
    }

    public static String createId(String type, String id) {
        if (id == null) {
            throw new NullPointerException("Cannot create from null id.");
        }
        if (id.isEmpty()) {
            throw new IllegalArgumentException("Cannot create from empty id.");
        }
        return ValueType.assertNotNullOrEmpty(type) ? type.toLowerCase().concat(SEPERATOR).concat(id) : id;
    }

    private static boolean assertNotNullOrEmpty(String type) {
        return type != null && !type.isEmpty();
    }
}

