/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.spi.search;

import com.fasterxml.jackson.annotation.JsonIgnore;

public abstract class SearchResult {
    private final String id;
    private final String label;
    private final String baseUrl;

    public SearchResult(String id, String label) {
        this(id, label, null);
    }

    public SearchResult(String id, String label, String baseUrl) {
        this.id = id;
        this.label = label;
        this.baseUrl = baseUrl != null && !baseUrl.endsWith("/") ? baseUrl.concat("/") : baseUrl;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean hasBaseUrl() {
        return this.baseUrl != null;
    }

    @JsonIgnore
    public String getBaseUrl() {
        return this.baseUrl;
    }

    protected String createFullHref() {
        return this.getBaseUrl() + this.getId();
    }

    public abstract String getHref();

    public abstract String getType();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchResult other = (SearchResult)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

