/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.spi.srv;

import java.text.Collator;
import java.util.Locale;
import org.n52.io.request.IoParameters;
import org.n52.io.response.OutputCollection;
import org.n52.io.response.ParameterOutput;
import org.n52.series.spi.srv.ParameterService;
import org.n52.series.spi.srv.RawDataService;

public class LocaleAwareSortService<T extends ParameterOutput>
extends ParameterService<T> {
    private final ParameterService<T> composedService;

    public LocaleAwareSortService(ParameterService<T> toCompose) {
        this.composedService = toCompose;
    }

    protected Collator createCollator(String locale) {
        return Collator.getInstance(new Locale(locale));
    }

    @Override
    public OutputCollection<T> getExpandedParameters(IoParameters query) {
        OutputCollection<T> result = this.composedService.getExpandedParameters(query);
        return result.withSortedItems(this.createCollator(query.getLocale()));
    }

    @Override
    public OutputCollection<T> getCondensedParameters(IoParameters query) {
        OutputCollection<T> result = this.composedService.getCondensedParameters(query);
        return result.withSortedItems(this.createCollator(query.getLocale()));
    }

    @Override
    public OutputCollection<T> getParameters(String[] items, IoParameters query) {
        OutputCollection<T> result = this.composedService.getParameters(items, query);
        return result.withSortedItems(this.createCollator(query.getLocale()));
    }

    @Override
    public T getParameter(String item, IoParameters query) {
        return this.composedService.getParameter(item, query);
    }

    @Override
    public boolean exists(String id, IoParameters parameters) {
        return this.composedService.exists(id, parameters);
    }

    @Override
    public RawDataService getRawDataService() {
        return this.composedService.getRawDataService();
    }

    @Override
    public boolean supportsRawData() {
        return this.composedService.supportsRawData();
    }
}

