/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.crs;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import org.junit.Before;
import org.junit.Test;
import org.n52.io.crs.CRSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeotoolsJTSReferenceTester {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeotoolsJTSReferenceTester.class);

    @Before
    public void setUp() {
    }

    @Test
    public void shouldBlah() throws Exception {
        CRSUtils forcedXYOrder = CRSUtils.createEpsgForcedXYAxisOrder();
        GeometryFactory xyFactory = forcedXYOrder.createGeometryFactory("EPSG:4326");
        Point forcedXYPoint = xyFactory.createPoint(new Coordinate(7.4, 52.3));
        LOGGER.info("EPSG:4326 as JTS point (forced XY): {}", (Object)forcedXYPoint);
        LOGGER.info("Transformed to EPSG:25832: {}", (Object)forcedXYOrder.transform((Geometry)forcedXYPoint, "EPSG:4326", "EPSG:25832"));
        CRSUtils respectEpsgOrder = CRSUtils.createEpsgStrictAxisOrder();
        GeometryFactory strictFactory = respectEpsgOrder.createGeometryFactory("EPSG:4326");
        Point strictPoint = strictFactory.createPoint(new Coordinate(52.3, 7.4));
        LOGGER.info("EPSG:4326 as JTS point (strict EPSG order): {}", (Object)strictPoint);
        LOGGER.info("Transformed to EPSG:25832: {}", (Object)respectEpsgOrder.transform((Geometry)strictPoint, "EPSG:4326", "EPSG:25832"));
    }

    @Test
    public void shouldCreateCRS84() throws Exception {
        CRSUtils respectEpsgOrder = CRSUtils.createEpsgStrictAxisOrder();
        GeometryFactory strictFactory = respectEpsgOrder.createGeometryFactory("EPSG:4326");
        Point strictPoint = strictFactory.createPoint(new Coordinate(52.3, 7.4));
        LOGGER.info("EPSG:4326 as JTS point (strict EPSG order): {}", (Object)strictPoint);
        LOGGER.info("Transformed to CRS:84: {}", (Object)respectEpsgOrder.transform((Geometry)strictPoint, "EPSG:4326", "CRS:84"));
    }
}

