/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.request;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.io.File;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.junit.Assert;
import org.junit.Test;
import org.n52.io.IntervalWithTimeZone;
import org.n52.io.crs.BoundingBox;
import org.n52.io.request.FilterResolver;
import org.n52.io.request.IoParameters;
import org.n52.io.request.RequestParameterSet;
import org.n52.io.request.RequestSimpleParameterSet;
import org.n52.io.request.RequestStyledParameterSet;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class IoParametersTest {
    private File getAlternativeConfigFile() throws URISyntaxException {
        Path root = Paths.get(this.getClass().getResource("/").toURI());
        return root.resolve("test-config.json").toFile();
    }

    @Test
    public void when_defaultTimezone_then_timezoneIsUTC() {
        IoParameters config = IoParameters.createDefaults();
        String timezone = config.getOutputTimezone();
        Assert.assertThat((Object)DateTimeZone.forID((String)timezone), (Matcher)Matchers.is((Object)DateTimeZone.UTC));
    }

    @Test
    public void when_jsonBbox_then_parsingSpatialFilter() throws ParseException {
        Map<String, String> map = Collections.singletonMap("bbox", "{\"ll\":{\"type\":\"Point\",\"coordinates\":[6.7,51.7]},\"ur\":{\"type\":\"Point\",\"coordinates\":[7.9,51.9]}}");
        IoParameters parameters = IoParameters.createFromSingleValueMap(map);
        BoundingBox actual = parameters.getSpatialFilter();
        WKTReader wktReader = new WKTReader();
        Geometry ll = wktReader.read("POINT (6.7 51.7)");
        Geometry ur = wktReader.read("POINT(7.9 51.9)");
        Assert.assertTrue((boolean)actual.getLowerLeft().equals(ll));
        Assert.assertTrue((boolean)actual.getUpperRight().equals(ur));
    }

    @Test
    public void when_creationViaFromSingleValuedMap_then_keysGetLowerCased() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("camelCased", "value");
        map.put("UPPERCASED", "value");
        IoParameters parameters = IoParameters.createFromSingleValueMap(map);
        Assert.assertTrue((boolean)parameters.containsParameter("camelCased"));
        Assert.assertTrue((boolean)parameters.containsParameter("camelcased"));
        Assert.assertTrue((boolean)parameters.containsParameter("UPPERCASED"));
        Assert.assertTrue((boolean)parameters.containsParameter("uppercased"));
    }

    @Test
    public void when_creationViaFromMultiValuedMap_then_keysGetLowerCased() {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"camelCased", (Object)"value");
        map.add((Object)"UPPERCASED", (Object)"value");
        IoParameters parameters = IoParameters.createFromMultiValueMap((MultiValueMap)map);
        Assert.assertTrue((boolean)parameters.containsParameter("camelCased"));
        Assert.assertTrue((boolean)parameters.containsParameter("camelcased"));
        Assert.assertTrue((boolean)parameters.containsParameter("UPPERCASED"));
        Assert.assertTrue((boolean)parameters.containsParameter("uppercased"));
    }

    @Test
    public void when_creationViaRequestParameterSet_then_keysGetLowerCased() {
        RequestSimpleParameterSet request = new RequestSimpleParameterSet();
        request.setParameter("camelCased", IoParameters.getJsonNodeFrom((Object)"value"));
        request.setParameter("UPPERCASED", IoParameters.getJsonNodeFrom((Object)"value"));
        IoParameters parameters = IoParameters.createFromQuery((RequestParameterSet)request);
        Assert.assertTrue((boolean)parameters.containsParameter("camelCased"));
        Assert.assertTrue((boolean)parameters.containsParameter("camelcased"));
        Assert.assertTrue((boolean)parameters.containsParameter("UPPERCASED"));
        Assert.assertTrue((boolean)parameters.containsParameter("uppercased"));
    }

    @Test
    public void when_defaults_then_valuesFromDefaultConfigFile() {
        IoParameters parameters = IoParameters.createDefaults();
        Assert.assertThat((Object)parameters.getWidth(), (Matcher)Matchers.is((Object)2000));
    }

    @Test
    public void when_createdWithConfig_then_widthIsOfAppropriateValue() throws URISyntaxException {
        IoParameters parameters = IoParameters.createDefaults((File)this.getAlternativeConfigFile());
        Assert.assertThat((Object)parameters.getWidth(), (Matcher)Matchers.is((Object)1000));
    }

    @Test
    public void testBooleanValue() {
        IoParameters parameters = IoParameters.createDefaults();
        Assert.assertTrue((boolean)parameters.isGeneralize());
    }

    @Test
    public void testAfterConvertedFromParameterSet() {
        IoParameters defaults = IoParameters.createDefaults();
        RequestSimpleParameterSet set = RequestSimpleParameterSet.createForSingleSeries((String)"1", (IoParameters)defaults);
        IoParameters parameters = IoParameters.createFromQuery((RequestParameterSet)set);
        Assert.assertTrue((boolean)parameters.isGeneralize());
    }

    @Test
    public void when_extending_then_parameterIsPresent() {
        IoParameters defaults = IoParameters.createDefaults();
        IoParameters extended = defaults.extendWith("test", new String[]{"value"});
        Assert.assertFalse((boolean)defaults.containsParameter("test"));
        Assert.assertTrue((boolean)extended.containsParameter("test"));
        Assert.assertThat((Object)extended.getAsString("test"), (Matcher)Matchers.is((Object)"value"));
    }

    @Test
    public void when_extendingMultiple_then_availableFromSet() {
        IoParameters defaults = IoParameters.createDefaults();
        IoParameters extended = defaults.extendWith("test", new String[]{"value1", "value2"});
        Assert.assertThat((Object)extended.getValuesOf("test").size(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void when_extendingCamelCased_then_parameterIsPresent() {
        IoParameters defaults = IoParameters.createDefaults();
        IoParameters extended = defaults.extendWith("testParameter", new String[]{"value"});
        Assert.assertFalse((boolean)defaults.containsParameter("testParameter"));
        Assert.assertTrue((boolean)extended.containsParameter("testParameter"));
        Assert.assertThat((Object)extended.getAsString("testParameter"), (Matcher)Matchers.is((Object)"value"));
    }

    @Test
    public void when_extending_then_valueObjectIsDifferent() {
        IoParameters defaults = IoParameters.createDefaults();
        IoParameters extended = defaults.extendWith("test", new String[]{"value"});
        Assert.assertFalse((defaults == extended ? 1 : 0) != 0);
    }

    @Test
    public void when_defaults_then_backwardCompatible() {
        FilterResolver filterResolver = IoParameters.createDefaults().getFilterResolver();
        Assert.assertThat((Object)filterResolver.shallBehaveBackwardsCompatible(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void when_convertingToStyledRequestParameters_then_overridingParametersAllowed() {
        IoParameters defaults = IoParameters.createDefaults().extendWith("width", new String[]{"200"});
        RequestStyledParameterSet parameters = defaults.toStyledParameterSet();
        Assert.assertThat((Object)parameters.getWidth(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void when_timespanWithNow_then_normalizeWithDateString() {
        DateTimeFormatter dateFormat = DateTimeFormat.forPattern((String)"YYYY-MM-dd");
        String now = dateFormat.print((ReadableInstant)new DateTime());
        IoParameters parameters = IoParameters.createDefaults().extendWith("timespan", new String[]{"PT4h/now"});
        IntervalWithTimeZone expected = new IntervalWithTimeZone("PT4h/" + now);
        Assert.assertThat((Object)parameters.getNormalizedTimespan(dateFormat), (Matcher)Matchers.is((Object)expected.toString()));
    }

    @Test
    public void when_singleFilter_then_filterPresentViaMultipleGetter() {
        IoParameters parameters = IoParameters.createDefaults().extendWith("procedure", new String[]{"foo"});
        Assert.assertThat((Object)parameters.getProcedures(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"foo"}));
    }

    @Test
    public void when_singleAndMultipleFilter_then_filterGetsMerged() {
        IoParameters parameters = IoParameters.createDefaults().extendWith("procedure", new String[]{"foo"}).extendWith("procedures", new String[]{"foo", "bar"});
        Assert.assertThat((Object)parameters.getProcedures(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"foo", "bar"}));
    }
}

