/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.response;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.n52.io.response.PlatformOutput;
import org.n52.io.response.PlatformType;

public class PlatformOutputTest {
    @Test
    public void when_createdMobileRemote_then_hrefIncludesPrefix() {
        PlatformOutput platform = new PlatformOutput(PlatformType.MOBILE_REMOTE);
        platform.setHrefBase("http://localhost/context");
        platform.setId("12");
        Assert.assertThat((Object)platform.getHref(), (Matcher)Matchers.is((Object)"http://localhost/context/mobile_remote_12"));
    }

    @Test
    public void when_createdStationaryRemote_then_hrefIncludesPrefix() {
        PlatformOutput platform = new PlatformOutput(PlatformType.STATIONARY_REMOTE);
        platform.setHrefBase("http://localhost/context");
        platform.setId("12");
        Assert.assertThat((Object)platform.getHref(), (Matcher)Matchers.is((Object)"http://localhost/context/stationary_remote_12"));
    }

    @Test
    public void when_createdStationaryInsitu_then_hrefIncludesPrefix() {
        PlatformOutput platform = new PlatformOutput(PlatformType.STATIONARY_INSITU);
        platform.setHrefBase("http://localhost/context");
        platform.setId("12");
        Assert.assertThat((Object)platform.getHref(), (Matcher)Matchers.is((Object)"http://localhost/context/stationary_insitu_12"));
    }

    @Test
    public void when_createdMobileInsitu_then_hrefIncludesPrefix() {
        PlatformOutput platform = new PlatformOutput(PlatformType.MOBILE_INSITU);
        platform.setHrefBase("http://localhost/context");
        platform.setId("12");
        Assert.assertThat((Object)platform.getHref(), (Matcher)Matchers.is((Object)"http://localhost/context/mobile_insitu_12"));
    }

    @Test
    public void when_havingExplicitHref_then_hrefNotIncludingHrefBase() {
        PlatformOutput platform = new PlatformOutput(PlatformType.MOBILE_INSITU);
        platform.setHref("http://localhost/otherContext/12");
        platform.setHrefBase("http://localhost/context");
        platform.setId("12");
        Assert.assertThat((Object)platform.getHref(), (Matcher)Matchers.is((Object)"http://localhost/otherContext/12"));
    }
}

