/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.response;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.n52.io.response.PlatformType;

public class PlatformTypeTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void when_mobileInsituString_then_recognizeType() {
        Assert.assertThat((Object)PlatformType.toInstance((String)"mobile_insitu"), (Matcher)Matchers.is((Object)PlatformType.MOBILE_INSITU));
    }

    @Test
    public void when_mobileRemoteString_then_recognizeType() {
        Assert.assertThat((Object)PlatformType.toInstance((String)"mobile_remote"), (Matcher)Matchers.is((Object)PlatformType.MOBILE_REMOTE));
    }

    @Test
    public void when_stationaryInsituString_then_recognizeType() {
        Assert.assertThat((Object)PlatformType.toInstance((String)"stationary_insitu"), (Matcher)Matchers.is((Object)PlatformType.STATIONARY_INSITU));
    }

    @Test
    public void when_stationaryRemoteString_then_recognizeType() {
        Assert.assertThat((Object)PlatformType.toInstance((String)"stationary_remote"), (Matcher)Matchers.is((Object)PlatformType.STATIONARY_REMOTE));
    }

    @Test
    public void when_unknownType_then_throwException() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("no type for 'does not exist'.");
        PlatformType.toInstance((String)"does not exist");
    }

    @Test
    public void when_extractingId_then_typePrefixGone() {
        Assert.assertThat((Object)PlatformType.extractId((String)"mobile_insitu_foobar"), (Matcher)Matchers.is((Object)"foobar"));
    }

    @Test
    public void when_extractingWithInvalidPrefix_then_expectIdentity() {
        Assert.assertThat((Object)PlatformType.extractId((String)"invalid_prefix"), (Matcher)Matchers.is((Object)"invalid_prefix"));
    }

    @Test
    public void when_stationaryOnlyPrefix_then_expectIdentity() {
        Assert.assertThat((Object)PlatformType.extractId((String)"stationary"), (Matcher)Matchers.is((Object)"stationary"));
    }

    @Test
    public void when_mobileOnlyPrefix_then_expectIdentity() {
        Assert.assertThat((Object)PlatformType.extractId((String)"mobile"), (Matcher)Matchers.is((Object)"mobile"));
    }

    @Test
    public void when_idWithStationaryPrefix_then_detectType() {
        Assert.assertTrue((boolean)PlatformType.isStationaryId((String)"stationary_remote_something"));
    }

    @Test
    public void when_idWithMobilePrefix_then_detectType() {
        Assert.assertTrue((boolean)PlatformType.isMobileId((String)"mobile_insitu_something"));
    }

    @Test
    public void when_idWithInsituSuffix_then_detectType() {
        Assert.assertTrue((boolean)PlatformType.isInsitu((String)"mobile_insitu_10"));
    }
}

