/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.crs;

import com.vividsolutions.jts.geom.Point;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.n52.io.crs.BoundingBox;
import org.n52.io.crs.CRSUtils;
import org.n52.io.geojson.old.GeojsonPoint;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.operation.TransformException;

public class CRSUtilsTest {
    private CRSUtils referenceHelper;
    private BoundingBox bbox;

    @Before
    public void setUp() throws Exception {
        this.referenceHelper = CRSUtils.createEpsgStrictAxisOrder();
        Point ll = this.referenceHelper.createPoint(Double.valueOf(6.4), Double.valueOf(51.9), "CRS:84");
        Point ur = this.referenceHelper.createPoint(Double.valueOf(8.9), Double.valueOf(53.4), "CRS:84");
        this.bbox = new BoundingBox(ll, ur, "CRS:84");
    }

    @Test
    public void shouldIndicateLatLonOrder() throws FactoryException {
        this.referenceHelper = CRSUtils.createEpsgStrictAxisOrder();
        Assert.assertThat((Object)this.referenceHelper.isLatLonAxesOrder("EPSG:4326"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldIndicateLonLatOrder() throws FactoryException {
        this.referenceHelper = CRSUtils.createEpsgForcedXYAxisOrder();
        Assert.assertThat((Object)this.referenceHelper.isLatLonAxesOrder("EPSG:4326"), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testIsStationContainedByBBox() throws NoSuchAuthorityCodeException, FactoryException, TransformException {
        GeojsonPoint stationWithin = this.getStationWithinBBox();
        GeojsonPoint stationOutside = this.getStationOutsideBBox();
        Assert.assertTrue((boolean)this.bbox.contains(this.referenceHelper.convertToPointFrom(stationWithin)));
        Assert.assertFalse((boolean)this.bbox.contains(this.referenceHelper.convertToPointFrom(stationOutside)));
    }

    private GeojsonPoint getStationWithinBBox() {
        return GeojsonPoint.createWithCoordinates((Double[])new Double[]{7.0, 52.0});
    }

    private GeojsonPoint getStationOutsideBBox() {
        return GeojsonPoint.createWithCoordinates((Double[])new Double[]{10.4, 52.0});
    }

    @Test
    public void testGetSrsIdFromEPSG() {
        this.assertValidCodeFromEpsg(4326, "4326");
        this.assertValidCodeFromEpsg(4326, "EPSG:4326");
        this.assertValidCodeFromEpsg(4326, "epsg:4326");
        this.assertValidCodeFromEpsg(4326, "epsg::4326");
        this.assertValidCodeFromEpsg(4326834, "ePsG:4326834");
        this.assertValidCodeFromEpsg(4326, "ogc:def:ref:epsg:4.7:4326");
    }

    private void assertValidCodeFromEpsg(int expected, String code) {
        Assert.assertEquals((String)"Unexpected EPSG code!", (long)expected, (long)this.referenceHelper.getSrsIdFromEPSG(code));
    }

    @Test
    public void testExtractSRSCode() {
        String smallCaseUrn = "urn:ogc:def:crs:epsg::4326";
        String capitalCaseUrn = "URN:OGC:DEF:CRS:EPSG:3.5:4326";
        String mixedCaseUrn = "UrN:OfC:dEf:crs:EPSG::4323426";
        String capitalEpsgLink = "http://www.opengis.net/def/crs/EPSG/0/4324336";
        String smallCaseEpsgLink = "http://www.opengis.net/def/crs/epsg/0/4326";
        this.assertValidEpsgShortCut("EPSG:4326", smallCaseUrn);
        this.assertValidEpsgShortCut("EPSG:4326", capitalCaseUrn);
        this.assertValidEpsgShortCut("EPSG:4323426", mixedCaseUrn);
        this.assertValidEpsgShortCut("EPSG:4324336", capitalEpsgLink);
        this.assertValidEpsgShortCut("EPSG:4326", smallCaseEpsgLink);
    }

    private void assertValidEpsgShortCut(String expected, String epsgCode) {
        Assert.assertEquals((String)"Unexpected EPSG string!", (Object)expected, (Object)this.referenceHelper.extractSRSCode(epsgCode));
    }
}

