/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.crs;

import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.n52.io.crs.CRSUtils;
import org.n52.io.crs.WGS84Util;
import org.opengis.referencing.FactoryException;

public class WGS84UtilTest {
    private static final double ERROR_DELTA = 0.01;
    private GeometryFactory factory;
    private CRSUtils helper;

    @Before
    public void setUp() {
        this.helper = CRSUtils.createEpsgForcedXYAxisOrder();
        this.factory = this.helper.createGeometryFactory("EPSG:4326");
    }

    @Test
    public void shouldCalculateShortestDistanceFromStatueOfLibertyToEiffelTower() throws FactoryException {
        Point statueOfLiberty = this.createXYOrderedWgs84Point(-74.0444, 40.6892);
        Point tourDeEiffel = this.createXYOrderedWgs84Point(2.2945, 48.8583);
        Assert.assertThat((Object)WGS84Util.shortestDistanceBetween((Point)statueOfLiberty, (Point)tourDeEiffel), (Matcher)Matchers.closeTo((double)5837.0, (double)0.5));
    }

    private Point createXYOrderedWgs84Point(double lon, double lat) throws FactoryException {
        return this.helper.createPoint(Double.valueOf(lon), Double.valueOf(lat), "EPSG:4326");
    }

    @Test
    public void shouldGetLongitudeDelta() throws FactoryException {
        Assert.assertThat((Object)WGS84Util.getLongitudeDelta((double)Math.toRadians(0.0), (double)40030.173592041145), (Matcher)Matchers.closeTo((double)0.0, (double)0.01));
        Assert.assertThat((Object)WGS84Util.getLongitudeDelta((double)Math.toRadians(0.0), (double)20015.086796020572), (Matcher)Matchers.closeTo((double)180.0, (double)0.01));
    }

    @Test
    public void shouldGetLatitudeDelta() throws FactoryException {
        Assert.assertThat((Object)WGS84Util.getLatitudeDelta((double)0.0), (Matcher)Matchers.closeTo((double)0.0, (double)0.01));
    }

    @Test
    public void shouldReturnNearZeroDistanceAtPoles() throws FactoryException {
        Assert.assertThat((Object)WGS84Util.getLatitutesCircleRadius((double)Math.toRadians(90.0)), (Matcher)Matchers.closeTo((double)0.0, (double)0.01));
        Assert.assertThat((Object)WGS84Util.getLatitutesCircleRadius((double)Math.toRadians(-90.0)), (Matcher)Matchers.closeTo((double)0.0, (double)0.01));
        Assert.assertThat((Object)WGS84Util.getLatitutesCircleRadius((double)Math.toRadians(270.0)), (Matcher)Matchers.closeTo((double)0.0, (double)0.01));
    }

    @Test
    public void shouldNormlizeLatitudesBiggerThan90Degrees() {
        double toNormalize = 91.4;
        double normalized = WGS84Util.normalizeLatitude((double)toNormalize);
        Assert.assertThat((Object)normalized, (Matcher)Matchers.closeTo((double)88.6, (double)0.01));
    }

    @Test
    public void shouldNormlizeLatitudesSmallerThanMinus90Degrees() {
        double toNormalize = -91.4;
        double normalized = WGS84Util.normalizeLatitude((double)toNormalize);
        Assert.assertThat((Object)normalized, (Matcher)Matchers.closeTo((double)-88.6, (double)0.01));
    }

    @Test
    public void shouldNotChangeZeroLatitudeDegrees() {
        double toNormalize = 0.0;
        double normalized = WGS84Util.normalizeLatitude((double)toNormalize);
        Assert.assertThat((Object)normalized, (Matcher)Matchers.closeTo((double)0.0, (double)0.01));
    }

    @Test
    public void shouldNormlizeLongitudesBiggerThan180Degrees() {
        double toNormalize = 182.3;
        double normalized = WGS84Util.normalizeLongitude((double)toNormalize);
        Assert.assertThat((Object)normalized, (Matcher)Matchers.closeTo((double)-177.7, (double)0.01));
    }

    @Test
    public void shouldNormlizeLongitudesSmallerThan180Degrees() {
        double toNormalize = -182.3;
        double normalized = WGS84Util.normalizeLongitude((double)toNormalize);
        Assert.assertThat((Object)normalized, (Matcher)Matchers.closeTo((double)177.7, (double)0.01));
    }

    @Test
    public void shouldNotChangeZeroLongitudeDegrees() {
        double toNormalize = 0.0;
        double normalized = WGS84Util.normalizeLongitude((double)toNormalize);
        Assert.assertThat((Object)normalized, (Matcher)Matchers.closeTo((double)0.0, (double)0.01));
    }
}

