/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.geojson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequenceComparator;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.io.IOException;
import java.util.Random;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;
import org.n52.io.geojson.GeoJSONDecoder;
import org.n52.io.geojson.GeoJSONEncoder;
import org.n52.io.geojson.GeoJSONException;

public class GeoJSONTest {
    @Rule
    public final ErrorCollector errors = new ErrorCollector();
    private final GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING));
    private final Random random = new Random();
    private final GeoJSONEncoder enc = new GeoJSONEncoder();
    private final GeoJSONDecoder dec = new GeoJSONDecoder();

    private Coordinate randomCoordinate() {
        return new Coordinate((double)this.random.nextInt(1000), (double)this.random.nextInt(1000));
    }

    private LineString randomLineString(int srid) {
        LineString geometry = this.geometryFactory.createLineString(new Coordinate[]{this.randomCoordinate(), this.randomCoordinate(), this.randomCoordinate()});
        geometry.setSRID(srid);
        return geometry;
    }

    private MultiLineString randomMultiLineString(int srid) {
        return this.geometryFactory.createMultiLineString(new LineString[]{this.randomLineString(srid), this.randomLineString(srid), this.randomLineString(srid)});
    }

    private Point randomPoint(int srid) {
        Point geometry = this.geometryFactory.createPoint(this.randomCoordinate());
        geometry.setSRID(srid);
        return geometry;
    }

    private LinearRing randomLinearRing(int srid) {
        Coordinate p = this.randomCoordinate();
        LinearRing geometry = this.geometryFactory.createLinearRing(new Coordinate[]{p, this.randomCoordinate(), this.randomCoordinate(), this.randomCoordinate(), p});
        geometry.setSRID(srid);
        return geometry;
    }

    private Polygon randomPolygon(int srid) {
        Polygon geometry = this.geometryFactory.createPolygon(this.randomLinearRing(srid), new LinearRing[]{this.randomLinearRing(srid), this.randomLinearRing(srid), this.randomLinearRing(srid)});
        geometry.setSRID(srid);
        return geometry;
    }

    private MultiPoint randomMultiPoint(int srid) {
        MultiPoint geometry = this.geometryFactory.createMultiPoint(new Coordinate[]{this.randomCoordinate(), this.randomCoordinate(), this.randomCoordinate(), this.randomCoordinate(), this.randomCoordinate(), this.randomCoordinate()});
        geometry.setSRID(srid);
        return geometry;
    }

    private MultiPolygon randomMultiPolygon(int srid) {
        MultiPolygon geometry = this.geometryFactory.createMultiPolygon(new Polygon[]{this.randomPolygon(srid), this.randomPolygon(srid), this.randomPolygon(srid)});
        geometry.setSRID(srid);
        return geometry;
    }

    private GeometryCollection randomGeometryCollection(int srid) {
        GeometryCollection geometry = this.geometryFactory.createGeometryCollection(new Geometry[]{this.randomPoint(srid), this.randomMultiPoint(srid), this.randomLineString(srid), this.randomMultiLineString(srid), this.randomPolygon(srid), this.randomMultiPolygon(srid)});
        geometry.setSRID(srid);
        return geometry;
    }

    @Test
    public void testGeometryCollection() throws GeoJSONException, IOException {
        this.readWriteTest((Geometry)this.geometryFactory.createGeometryCollection(new Geometry[]{this.randomGeometryCollection(4326), this.randomGeometryCollection(2000)}));
    }

    @Test
    public void testGeometryCollectionWithZCoordinate() throws GeoJSONException, IOException {
        GeometryCollection geometry = this.geometryFactory.createGeometryCollection(new Geometry[]{this.randomGeometryCollection(4326), this.randomGeometryCollection(2000)});
        geometry.apply((CoordinateFilter)new RandomZCoordinateFilter());
        geometry.geometryChanged();
        this.readWriteTest((Geometry)geometry);
    }

    @Test
    public void testPolygon() throws GeoJSONException, IOException {
        this.readWriteTest((Geometry)this.randomPolygon(4326));
    }

    @Test
    public void testPolygonWithZCoordinate() throws GeoJSONException, IOException {
        Polygon geometry = this.randomPolygon(4326);
        geometry.apply((CoordinateFilter)new RandomZCoordinateFilter());
        geometry.geometryChanged();
        this.readWriteTest((Geometry)geometry);
    }

    @Test
    public void testMultiPolygon() throws GeoJSONException, IOException {
        this.readWriteTest((Geometry)this.randomMultiPolygon(4326));
    }

    @Test
    public void testMultiPolygonWithZCoordinate() throws GeoJSONException, IOException {
        MultiPolygon geometry = this.randomMultiPolygon(4326);
        geometry.apply((CoordinateFilter)new RandomZCoordinateFilter());
        geometry.geometryChanged();
        this.readWriteTest((Geometry)geometry);
    }

    @Test
    public void testPoint() throws GeoJSONException, IOException {
        this.readWriteTest((Geometry)this.randomPoint(2000));
    }

    @Test
    public void testCrsCombinations() throws GeoJSONException, IOException {
        this.testCrs(0, 0);
        this.testCrs(2000, 0);
        this.testCrs(4326, 0);
        this.testCrs(4326, 2000);
        this.testCrs(0, 2000);
        this.testCrs(0, 4326);
        this.testCrs(2000, 2000);
        this.testCrs(4326, 4326);
        this.testCrs(2000, 2001);
    }

    private void testCrs(int parent, int child) {
        GeometryCollection col = this.geometryFactory.createGeometryCollection(new Geometry[]{this.randomPoint(child)});
        col.setSRID(parent);
        this.readWriteTest((Geometry)col);
    }

    @Test
    public void testPointWithZCoordinate() throws GeoJSONException, IOException {
        Point geometry = this.randomPoint(2000);
        geometry.apply((CoordinateFilter)new RandomZCoordinateFilter());
        geometry.geometryChanged();
        this.readWriteTest((Geometry)geometry);
    }

    @Test
    public void testMultiPoint() {
        this.readWriteTest((Geometry)this.randomMultiPoint(4326));
    }

    @Test
    public void testMultiPointWithZCoordinate() {
        MultiPoint geometry = this.randomMultiPoint(4326);
        geometry.apply((CoordinateFilter)new RandomZCoordinateFilter());
        geometry.geometryChanged();
        this.readWriteTest((Geometry)geometry);
    }

    @Test
    public void testLineString() {
        this.readWriteTest((Geometry)this.randomLineString(4326));
    }

    @Test
    public void testLineStringWithZCoordinate() {
        LineString geometry = this.randomLineString(4326);
        geometry.apply((CoordinateFilter)new RandomZCoordinateFilter());
        geometry.geometryChanged();
        this.readWriteTest((Geometry)geometry);
    }

    @Test
    public void testMultiLineString() {
        this.readWriteTest((Geometry)this.randomMultiLineString(4326));
    }

    @Test
    public void testMultiLineStringWithZCoordinate() {
        MultiLineString geometry = this.randomMultiLineString(4326);
        geometry.apply((CoordinateFilter)new RandomZCoordinateFilter());
        geometry.geometryChanged();
        this.readWriteTest((Geometry)geometry);
    }

    protected void readWriteTest(Geometry geom) {
        try {
            ObjectNode json = this.enc.encodeGeometry(geom);
            Geometry parsed = this.dec.decodeGeometry((JsonNode)json);
            ObjectNode json2 = this.enc.encodeGeometry(parsed);
            this.errors.checkThat((Object)geom, Matchers.is((Matcher)Matchers.equalTo((Object)parsed)));
            this.errors.checkThat((Object)json, Matchers.is((Matcher)Matchers.equalTo((Object)json2)));
        }
        catch (GeoJSONException ex) {
            this.errors.addError((Throwable)ex);
        }
    }

    @Test
    public void testNull() throws GeoJSONException {
        Assert.assertThat((Object)this.enc.encodeGeometry(null), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test(expected=GeoJSONException.class)
    public void testUnknownGeometry() throws GeoJSONException {
        this.enc.encodeGeometry((Geometry)new UnknownGeometry(this.geometryFactory));
    }

    @Test
    public void testEmpty() throws GeoJSONException {
        Assert.assertThat((Object)this.enc.encodeGeometry((Geometry)new EmptyGeometry(this.geometryFactory)), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    private class EmptyGeometry
    extends UnknownGeometry {
        private static final long serialVersionUID = 1L;

        EmptyGeometry(GeometryFactory factory) {
            super(factory);
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }

    private class UnknownGeometry
    extends Geometry {
        private static final long serialVersionUID = 1L;
        private final String type = "geom";
        private final Point delegate;

        UnknownGeometry(GeometryFactory factory) {
            super(factory);
            this.type = "geom";
            this.delegate = GeoJSONTest.this.geometryFactory.createPoint(new Coordinate(1.0, 2.0, 3.0));
        }

        public String getGeometryType() {
            return "geom";
        }

        public Coordinate getCoordinate() {
            return this.delegate.getCoordinate();
        }

        public Coordinate[] getCoordinates() {
            return this.delegate.getCoordinates();
        }

        public int getNumPoints() {
            return this.delegate.getNumPoints();
        }

        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        public int getDimension() {
            return this.delegate.getDimension();
        }

        public Geometry getBoundary() {
            return this.delegate.getBoundary();
        }

        public int getBoundaryDimension() {
            return this.delegate.getBoundaryDimension();
        }

        public Geometry reverse() {
            return this.delegate.reverse();
        }

        public boolean equalsExact(Geometry other, double tolerance) {
            return this.delegate.equalsExact(other, tolerance);
        }

        public void apply(CoordinateFilter filter) {
            this.delegate.apply(filter);
        }

        public void apply(CoordinateSequenceFilter filter) {
            this.delegate.apply(filter);
        }

        public void apply(GeometryFilter filter) {
            this.delegate.apply(filter);
        }

        public void apply(GeometryComponentFilter filter) {
            this.delegate.apply(filter);
        }

        public void normalize() {
            this.delegate.normalize();
        }

        protected Envelope computeEnvelopeInternal() {
            return this.delegate.getEnvelopeInternal();
        }

        protected int compareToSameClass(Object o) {
            return this.delegate.compareTo(o);
        }

        protected int compareToSameClass(Object o, CoordinateSequenceComparator comp) {
            return this.delegate.compareTo(o, comp);
        }
    }

    private class RandomZCoordinateFilter
    implements CoordinateFilter {
        private RandomZCoordinateFilter() {
        }

        public void filter(Coordinate coord) {
            coord.z = GeoJSONTest.this.random.nextInt(1000);
        }
    }
}

