/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.request;

import org.junit.Assert;
import org.junit.Test;
import org.n52.io.request.FilterResolver;
import org.n52.io.request.IoParameters;

public class FilterResolverTest {
    private FilterResolver createResolver(IoParameters resolver) {
        return new FilterResolver(resolver);
    }

    @Test
    public void when_defaults_then_behaveBackwardsCompatible() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults());
        Assert.assertTrue((boolean)resolver.shallBehaveBackwardsCompatible());
    }

    @Test
    public void when_setPlatformTypeFilter_then_dontBehaveBackwardsCompatible() {
        IoParameters parameters = IoParameters.createDefaults().extendWith("platformTypes", new String[]{"blah"});
        FilterResolver resolver = this.createResolver(parameters);
        Assert.assertFalse((boolean)resolver.shallBehaveBackwardsCompatible());
    }

    @Test
    public void when_setDatasetTypeFiltre_then_dontBehaveBackwardsCompatible() {
        IoParameters parameters = IoParameters.createDefaults().extendWith("valueTypes", new String[]{"blah"});
        FilterResolver resolver = this.createResolver(parameters);
        Assert.assertFalse((boolean)resolver.shallBehaveBackwardsCompatible());
    }

    @Test
    public void when_defaults_then_allPlatformGeometryFiltersActive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults());
        Assert.assertTrue((boolean)resolver.shallIncludePlatformGeometriesSite());
        Assert.assertTrue((boolean)resolver.shallIncludePlatformGeometriesTrack());
    }

    @Test
    public void when_defaults_then_allObservedGeometryFiltersActive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults());
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesDynamic());
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesStatic());
    }

    @Test
    public void when_stationaryPlatformsFilter_then_sitesAndAndRemoteFilterActive() {
        IoParameters parameters = IoParameters.createDefaults().extendWith("platformTypes", new String[]{"stationary"});
        FilterResolver resolver = this.createResolver(parameters);
        Assert.assertTrue((boolean)resolver.shallIncludePlatformGeometriesSite());
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesStatic());
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesDynamic());
        Assert.assertFalse((boolean)resolver.shallIncludePlatformGeometriesTrack());
    }

    @Test
    public void when_mobilePlatformsFilter_then_tracksAndRemoteFilterActive() {
        IoParameters parameters = IoParameters.createDefaults().extendWith("platformTypes", new String[]{"mobile"});
        FilterResolver resolver = this.createResolver(parameters);
        Assert.assertTrue((boolean)resolver.shallIncludePlatformGeometriesTrack());
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesDynamic());
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesStatic());
        Assert.assertFalse((boolean)resolver.shallIncludePlatformGeometriesSite());
    }

    @Test
    public void when_insituPlatformsFilter_then_sitesAndtracksFilterActive() {
        IoParameters parameters = IoParameters.createDefaults().extendWith("platformTypes", new String[]{"insitu"});
        FilterResolver resolver = this.createResolver(parameters);
        Assert.assertTrue((boolean)resolver.shallIncludePlatformGeometriesSite());
        Assert.assertTrue((boolean)resolver.shallIncludePlatformGeometriesTrack());
        Assert.assertFalse((boolean)resolver.shallIncludeObservedGeometriesStatic());
        Assert.assertFalse((boolean)resolver.shallIncludeObservedGeometriesDynamic());
    }

    @Test
    public void when_remotePlatformsFilter_then_allGeometriesFilterActive() {
        IoParameters parameters = IoParameters.createDefaults().extendWith("platformTypes", new String[]{"remote"});
        FilterResolver resolver = this.createResolver(parameters);
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesStatic());
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesDynamic());
        Assert.assertFalse((boolean)resolver.shallIncludePlatformGeometriesTrack());
        Assert.assertFalse((boolean)resolver.shallIncludePlatformGeometriesSite());
    }

    @Test
    public void when_allObservedGeometries_then_allObservedGeometryFiltersActive() {
        IoParameters parameters = IoParameters.createDefaults().extendWith("observedGeometries", new String[]{"all"});
        FilterResolver resolver = this.createResolver(parameters);
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesDynamic());
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesStatic());
    }

    @Test
    public void when_allPlatformGeometries_then_allPlatformGeometryFiltersActive() {
        IoParameters parameters = IoParameters.createDefaults().extendWith("platformGeometries", new String[]{"all"});
        FilterResolver resolver = this.createResolver(parameters);
        Assert.assertTrue((boolean)resolver.shallIncludePlatformGeometriesSite());
        Assert.assertTrue((boolean)resolver.shallIncludePlatformGeometriesTrack());
    }

    @Test
    public void when_allPlatformsRemoteGeometries_then_allGeometriesFilterActive() {
        IoParameters parameters = IoParameters.createDefaults().extendWith("platformTypes", new String[]{"remote"}).extendWith("observedGeometries", new String[]{"all"});
        FilterResolver resolver = this.createResolver(parameters);
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesStatic());
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesDynamic());
        Assert.assertFalse((boolean)resolver.shallIncludePlatformGeometriesTrack());
        Assert.assertFalse((boolean)resolver.shallIncludePlatformGeometriesSite());
    }

    @Test
    public void when_allGeometriesStationaryPlatforms_then_allSitesFilterActive() {
        IoParameters parameters = IoParameters.createDefaults().extendWith("observedGeometries", new String[]{"all"}).extendWith("platformTypes", new String[]{"stationary"});
        FilterResolver resolver = this.createResolver(parameters);
        Assert.assertTrue((boolean)resolver.shallIncludePlatformGeometriesSite());
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesStatic());
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesDynamic());
        Assert.assertFalse((boolean)resolver.shallIncludePlatformGeometriesTrack());
    }

    @Test
    public void when_allGeometriesMobilePlatforms_then_allTracksFilterActive() {
        IoParameters parameters = IoParameters.createDefaults().extendWith("platformTypes", new String[]{"mobile"}).extendWith("observedGeometries", new String[]{"all"});
        FilterResolver resolver = this.createResolver(parameters);
        Assert.assertTrue((boolean)resolver.shallIncludePlatformGeometriesTrack());
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesDynamic());
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesStatic());
        Assert.assertFalse((boolean)resolver.shallIncludePlatformGeometriesSite());
    }

    @Test
    public void when_sitePlatformGeometries_then_siteFilterActive() {
        IoParameters parameters = IoParameters.createDefaults().extendWith("platformGeometries", new String[]{"site"});
        FilterResolver resolver = this.createResolver(parameters);
        Assert.assertTrue((boolean)resolver.shallIncludePlatformGeometriesSite());
        Assert.assertFalse((boolean)resolver.shallIncludePlatformGeometriesTrack());
    }

    @Test
    public void when_trackPlatformGeometries_then_trackFilterActive() {
        IoParameters parameters = IoParameters.createDefaults().extendWith("platformGeometries", new String[]{"track"});
        FilterResolver resolver = this.createResolver(parameters);
        Assert.assertTrue((boolean)resolver.shallIncludePlatformGeometriesTrack());
    }

    @Test
    public void when_trackPlatformGeometries_then_siteFilterInactive() {
        IoParameters parameters = IoParameters.createDefaults().extendWith("platformGeometries", new String[]{"track"});
        FilterResolver resolver = this.createResolver(parameters);
        Assert.assertFalse((boolean)resolver.shallIncludePlatformGeometriesSite());
    }

    @Test
    public void when_staticObservedGeometries_then_staticFilterActive() {
        IoParameters parameters = IoParameters.createDefaults().extendWith("observedGeometries", new String[]{"static"});
        FilterResolver resolver = this.createResolver(parameters);
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesStatic());
        Assert.assertFalse((boolean)resolver.shallIncludeObservedGeometriesDynamic());
        Assert.assertFalse((boolean)resolver.shallIncludePlatformGeometriesTrack());
        Assert.assertFalse((boolean)resolver.shallIncludePlatformGeometriesSite());
    }

    @Test
    public void when_dynamicObservedGeometries_then_dynamicFilterActive() {
        IoParameters parameters = IoParameters.createDefaults().extendWith("observedGeometries", new String[]{"dynamic"});
        FilterResolver resolver = this.createResolver(parameters);
        Assert.assertTrue((boolean)resolver.shallIncludeObservedGeometriesDynamic());
        Assert.assertFalse((boolean)resolver.shallIncludeObservedGeometriesStatic());
        Assert.assertFalse((boolean)resolver.shallIncludePlatformGeometriesTrack());
        Assert.assertFalse((boolean)resolver.shallIncludePlatformGeometriesSite());
    }

    @Test
    public void when_defaults_then_insituFilterActive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults());
        Assert.assertTrue((boolean)resolver.shallIncludeInsituPlatformTypes());
    }

    @Test
    public void when_defaults_then_stationaryFilterActive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults());
        Assert.assertTrue((boolean)resolver.shallIncludeStationaryPlatformTypes());
    }

    @Test
    public void when_defaults_then_remoteFilterInactive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults());
        Assert.assertTrue((boolean)resolver.shallIncludeRemotePlatformTypes());
    }

    @Test
    public void when_defaults_then_mobileFilterInactive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults());
        Assert.assertTrue((boolean)resolver.shallIncludeMobilePlatformTypes());
    }

    @Test
    public void when_setMobile_then_allMobilesFilterActive() {
        IoParameters parameters = IoParameters.createDefaults().extendWith("platformTypes", new String[]{"mobile"});
        FilterResolver resolver = this.createResolver(parameters);
        Assert.assertTrue((boolean)resolver.shallIncludeMobilePlatformTypes());
        Assert.assertTrue((boolean)resolver.shallIncludeInsituPlatformTypes());
        Assert.assertTrue((boolean)resolver.shallIncludeRemotePlatformTypes());
        Assert.assertFalse((boolean)resolver.shallIncludeStationaryPlatformTypes());
    }

    @Test
    public void when_setRemote_then_allRemotesFilterActive() {
        FilterResolver resolver = this.createResolver(IoParameters.createDefaults().extendWith("platformTypes", new String[]{"remote"}));
        Assert.assertTrue((boolean)resolver.shallIncludeRemotePlatformTypes());
        Assert.assertTrue((boolean)resolver.shallIncludeMobilePlatformTypes());
        Assert.assertTrue((boolean)resolver.shallIncludeStationaryPlatformTypes());
        Assert.assertFalse((boolean)resolver.shallIncludeInsituPlatformTypes());
    }

    @Test
    public void when_setMobileRemote_then_allMobileRemotesFilterActive() {
        IoParameters parameters = IoParameters.createDefaults().extendWith("platformTypes", new String[]{"mobile", "remote"});
        FilterResolver resolver = this.createResolver(parameters);
        Assert.assertTrue((boolean)resolver.shallIncludeMobilePlatformTypes());
        Assert.assertTrue((boolean)resolver.shallIncludeRemotePlatformTypes());
        Assert.assertFalse((boolean)resolver.shallIncludeInsituPlatformTypes());
        Assert.assertFalse((boolean)resolver.shallIncludeStationaryPlatformTypes());
    }

    @Test
    public void when_setMobileInsitu_then_allMobileInsitusFilterActive() {
        IoParameters parameters = IoParameters.createDefaults().extendWith("platformTypes", new String[]{"mobile", "insitu"});
        FilterResolver resolver = this.createResolver(parameters);
        Assert.assertTrue((boolean)resolver.shallIncludeMobilePlatformTypes());
        Assert.assertTrue((boolean)resolver.shallIncludeInsituPlatformTypes());
        Assert.assertFalse((boolean)resolver.shallIncludeStationaryPlatformTypes());
        Assert.assertFalse((boolean)resolver.shallIncludeRemotePlatformTypes());
    }

    @Test
    public void when_setStationaryInsitu_then_allStationaryInsitusFilterActive() {
        IoParameters parameters = IoParameters.createDefaults().extendWith("platformTypes", new String[]{"stationary", "insitu"});
        FilterResolver resolver = this.createResolver(parameters);
        Assert.assertTrue((boolean)resolver.shallIncludeInsituPlatformTypes());
        Assert.assertTrue((boolean)resolver.shallIncludeStationaryPlatformTypes());
        Assert.assertFalse((boolean)resolver.shallIncludeMobilePlatformTypes());
        Assert.assertFalse((boolean)resolver.shallIncludeRemotePlatformTypes());
    }

    @Test
    public void when_setStationaryRemote_then_allStationaryRemotesFilterActive() {
        IoParameters parameters = IoParameters.createDefaults().extendWith("platformTypes", new String[]{"stationary", "remote"});
        FilterResolver resolver = this.createResolver(parameters);
        Assert.assertTrue((boolean)resolver.shallIncludeStationaryPlatformTypes());
        Assert.assertTrue((boolean)resolver.shallIncludeRemotePlatformTypes());
        Assert.assertFalse((boolean)resolver.shallIncludeInsituPlatformTypes());
        Assert.assertFalse((boolean)resolver.shallIncludeMobilePlatformTypes());
    }

    @Test
    public void when_setAllPlatformTypes_then_insituFilterActive() {
        IoParameters parameters = IoParameters.createDefaults().extendWith("platformTypes", new String[]{"all"});
        FilterResolver resolver = this.createResolver(parameters);
        Assert.assertTrue((boolean)resolver.shallIncludeInsituPlatformTypes());
    }

    @Test
    public void when_setAllPlatformTypes_then_stationaryFilterActive() {
        IoParameters parameters = IoParameters.createDefaults().extendWith("platformTypes", new String[]{"all"});
        FilterResolver resolver = this.createResolver(parameters);
        Assert.assertTrue((boolean)resolver.shallIncludeStationaryPlatformTypes());
    }

    @Test
    public void when_setAllPlatformTypes_then_remoteFilterActive() {
        IoParameters parameters = IoParameters.createDefaults().extendWith("platformTypes", new String[]{"all"});
        FilterResolver resolver = this.createResolver(parameters);
        Assert.assertTrue((boolean)resolver.shallIncludeRemotePlatformTypes());
    }

    @Test
    public void when_setAllPlatformTypes_then_mobileFilterActive() {
        IoParameters parameters = IoParameters.createDefaults().extendWith("platformTypes", new String[]{"all"});
        FilterResolver resolver = this.createResolver(parameters);
        Assert.assertTrue((boolean)resolver.shallIncludeMobilePlatformTypes());
    }

    @Test
    public void when_setAllDatasetTypes_then_noFilterActive() {
        IoParameters parameters = IoParameters.createDefaults().extendWith("valueTypes", new String[]{"all"});
        FilterResolver resolver = this.createResolver(parameters);
        Assert.assertTrue((boolean)resolver.shallIncludeAllDatasetTypes());
    }

    @Test
    public void when_setDatasetTypeFilter_then_filterActive() {
        IoParameters parameters = IoParameters.createDefaults().extendWith("valueTypes", new String[]{"foobar"});
        FilterResolver resolver = this.createResolver(parameters);
        Assert.assertFalse((boolean)resolver.shallIncludeAllDatasetTypes());
        Assert.assertTrue((boolean)resolver.shallIncludeDatasetType("foobar"));
    }
}

