/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.request;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.n52.io.request.RequestParameterSet;
import org.n52.io.request.RequestSimpleParameterSet;

public class RequestParameterSetTest {
    private JsonNodeFactory jsonFactory = JsonNodeFactory.instance;

    private RequestParameterSet createDummyParameterSet() {
        return new RequestParameterSet(){

            public String[] getDatasets() {
                return null;
            }
        };
    }

    @Test
    public void when_stringParameterNotPresent_then_returnNullInsteadOfExceptions() {
        RequestParameterSet parameterset = this.createDummyParameterSet();
        MatcherAssert.assertThat((Object)parameterset.getAsString("notthere"), (Matcher)Matchers.nullValue(String.class));
    }

    @Test
    public void when_stringParameterNotPresent_then_returnDefault() {
        RequestParameterSet parameterset = this.createDummyParameterSet();
        MatcherAssert.assertThat((Object)parameterset.getAsString("notthere", "value"), (Matcher)CoreMatchers.is((Object)"value"));
    }

    @Test
    public void when_booleanParameterNotPresent_then_returnNullInsteadOfExceptions() {
        RequestParameterSet parameterset = this.createDummyParameterSet();
        MatcherAssert.assertThat((Object)parameterset.getAsBoolean("notthere"), (Matcher)Matchers.nullValue(Boolean.class));
    }

    @Test
    public void when_intParameterNotPresent_then_returnDefault() {
        RequestParameterSet parameterset = this.createDummyParameterSet();
        MatcherAssert.assertThat((Object)parameterset.getAsInt("notthere", Integer.valueOf(-99)), (Matcher)CoreMatchers.is((Object)-99));
    }

    @Test
    public void when_intParameterNotPresent_then_returnNullInsteadOfExceptions() {
        RequestParameterSet parameterset = this.createDummyParameterSet();
        MatcherAssert.assertThat((Object)parameterset.getAsInt("notthere"), (Matcher)Matchers.nullValue(Integer.class));
    }

    @Test
    public void when_booleanParameterNotPresent_then_returnDefault() {
        RequestParameterSet parameterset = this.createDummyParameterSet();
        MatcherAssert.assertThat((Object)parameterset.getAsBoolean("notthere", Boolean.valueOf(false)), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void when_addingCamelCasedParameter_then_caseSensitiveAccess() {
        RequestParameterSet parameterset = this.createDummyParameterSet();
        parameterset.setParameter("myParameter", (JsonNode)this.jsonFactory.textNode("value"));
        MatcherAssert.assertThat((Object)parameterset.containsParameter("myParameter"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void when_addingCamelCasedParameter_then_caseInsensitiveAccess() {
        RequestParameterSet parameterset = this.createDummyParameterSet();
        parameterset.setParameter("myParameter", (JsonNode)this.jsonFactory.textNode("value"));
        MatcherAssert.assertThat((Object)parameterset.containsParameter("myparameter"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void when_datasetsAvailable_then_accessibleViaParameterName() {
        RequestSimpleParameterSet request = new RequestSimpleParameterSet();
        request.setParameter("datasets", (JsonNode)this.jsonFactory.arrayNode().add("foo").add("bar"));
        String[] actualValues = (String[])request.getAs(String[].class, "datasets");
        MatcherAssert.assertThat(Arrays.asList(actualValues), (Matcher)Matchers.contains((Object[])new String[]{"foo", "bar"}));
    }

    @Test
    public void when_addingSingleValueStringArray_then_accessibleViaParameterName() {
        RequestSimpleParameterSet request = new RequestSimpleParameterSet();
        request.setParameter("datasets", (JsonNode)this.jsonFactory.arrayNode().add("foo"));
        String[] actualValues = (String[])request.getAs(String[].class, "datasets");
        MatcherAssert.assertThat(Arrays.asList(actualValues), (Matcher)Matchers.contains((Object[])new String[]{"foo"}));
    }

    @Test
    public void when_addingStringArray_then_accessibleViaParameterName() {
        RequestParameterSet parameterset = this.createDummyParameterSet();
        ArrayNode array = this.jsonFactory.arrayNode().add("foo").add("bar");
        parameterset.setParameter("myParameter", (JsonNode)array);
        MatcherAssert.assertThat(Arrays.asList(parameterset.getAsStringArray("myparameter")), (Matcher)Matchers.contains((Object[])new String[]{"foo", "bar"}));
    }

    @Test
    public void when_datasetsAvailable_then_accessibleViaGetter() {
        RequestSimpleParameterSet request = new RequestSimpleParameterSet();
        request.setParameter("datasets", (JsonNode)this.jsonFactory.arrayNode().add("foo").add("bar"));
        MatcherAssert.assertThat(Arrays.asList(request.getDatasets()), (Matcher)Matchers.contains((Object[])new String[]{"foo", "bar"}));
    }
}

