/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.response;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.n52.io.response.OptionalOutput;

public class OptionalOutputTest {
    @Test
    public void when_created_then_defaultIsToSerialize() {
        OptionalOutput optional = OptionalOutput.of((Object)"42");
        MatcherAssert.assertThat((Object)optional.isSerialize(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void when_createdWithFalseSerialization_then_valueIsNotToSerialize() {
        OptionalOutput optional = OptionalOutput.of((Object)"42", (boolean)false);
        MatcherAssert.assertThat((Object)optional.isSerialize(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void when_createdWithValue_then_valueIsPresent() {
        OptionalOutput optional = OptionalOutput.of((Object)"42");
        MatcherAssert.assertThat((Object)optional.isPresent(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void when_createdWithFalseSerialization_then_valueIsPresent() {
        OptionalOutput optional = OptionalOutput.of((Object)"42", (boolean)false);
        MatcherAssert.assertThat((Object)optional.isPresent(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void when_createdWithNull_then_valueIsAbsent() {
        OptionalOutput optional = OptionalOutput.of(null);
        MatcherAssert.assertThat((Object)optional.isAbsent(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void when_created_then_valueIsReturned() {
        OptionalOutput optional = OptionalOutput.of((Object)"42");
        MatcherAssert.assertThat((Object)optional.getValue(), (Matcher)Matchers.is((Object)"42"));
    }

    @Test
    public void when_createdWithFalseSerialization_then_valueIsNotReturned() {
        OptionalOutput optional = OptionalOutput.of((Object)"42", (boolean)false);
        MatcherAssert.assertThat((Object)optional.getValue(), (Matcher)Matchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

