/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.response;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.n52.io.response.OptionalOutput;
import org.n52.io.response.ParameterOutput;

public class ParameterOutputTest {
    private <T> T resolve(T value, Function<OptionalOutput<T>, T> resolver) {
        return this.resolve(value, resolver, true);
    }

    private <T> T resolve(T value, Function<OptionalOutput<T>, T> resolver, boolean serialize) {
        return this.resolve(OptionalOutput.of(value, (boolean)serialize), resolver);
    }

    private <T> T resolve(OptionalOutput<T> optional, Function<OptionalOutput<T>, T> resolver) {
        return resolver.apply(optional);
    }

    @Test
    public void when_nullCollection_then_serializedCollectionIsNull() {
        ParameterOutput output = new ParameterOutput(){};
        Collection actual = this.resolve((Collection)null, arg_0 -> ((ParameterOutput)output).getIfSerializedCollection(arg_0));
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void when_nullMap_then_serializedMapIsNull() {
        ParameterOutput output = new ParameterOutput(){};
        Map actual = this.resolve((Map)null, arg_0 -> ((ParameterOutput)output).getIfSerializedMap(arg_0));
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void when_emptyCollection_then_serializedCollectionIsNull() {
        ParameterOutput output = new ParameterOutput(){};
        Collection actual = this.resolve(Collections.emptyList(), arg_0 -> ((ParameterOutput)output).getIfSerializedCollection(arg_0));
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void when_emptyMap_then_serializedMapIsNull() {
        ParameterOutput output = new ParameterOutput(){};
        Map actual = this.resolve(Collections.emptyMap(), arg_0 -> ((ParameterOutput)output).getIfSerializedMap(arg_0));
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void when_emptyNonSerializationCollection_then_serializedCollectionIsNull() {
        ParameterOutput output = new ParameterOutput(){};
        Collection actual = this.resolve(Collections.emptyList(), arg_0 -> ((ParameterOutput)output).getIfSerializedCollection(arg_0));
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void when_emptyNonSerializationMap_then_serializedMapIsNull() {
        ParameterOutput output = new ParameterOutput(){};
        Map actual = this.resolve(Collections.emptyMap(), arg_0 -> ((ParameterOutput)output).getIfSerializedMap(arg_0));
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void when_nonEmptyNonSerializationCollection_then_serializedCollection() {
        ParameterOutput output = new ParameterOutput(){};
        Collection actual = this.resolve(Collections.singleton("foo"), arg_0 -> ((ParameterOutput)output).getIfSerializedCollection(arg_0));
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
    }

    @Test
    public void when_nonEmptyNonSerializationMap_then_serializedMap() {
        ParameterOutput output = new ParameterOutput(){};
        Map actual = this.resolve(Collections.singletonMap("foo", "bar"), arg_0 -> ((ParameterOutput)output).getIfSerializedMap(arg_0));
        MatcherAssert.assertThat(actual.keySet(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
    }

    @Test
    public void when_nonEmptyNonSerializationCollection_then_serializedCollectionIsNull() {
        ParameterOutput output = new ParameterOutput(){};
        Collection actual = this.resolve(Collections.singleton("foo"), arg_0 -> ((ParameterOutput)output).getIfSerializedCollection(arg_0), false);
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void when_nonEmptyNonSerializationMap_then_serializedMapIsNull() {
        ParameterOutput output = new ParameterOutput(){};
        Map actual = this.resolve(Collections.singletonMap("foo", "bar"), arg_0 -> ((ParameterOutput)output).getIfSerializedMap(arg_0), false);
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

