/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.response.dataset;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.n52.io.response.dataset.ValueType;

public class ValueTypeTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void when_extractingIdWithoutUnderscore_then_extractIdentity() {
        Assert.assertThat((Object)ValueType.extractId((String)"1"), (Matcher)Matchers.is((Object)"1"));
    }

    @Test
    public void when_nullDatasetId_then_extractDefaultFallback() {
        Assert.assertThat((Object)ValueType.extractType(null), (Matcher)Matchers.is((Object)"quantity"));
    }

    @Test
    public void when_emptyDatasetIdAndEmptyFallback_then_extractDefaultFallback() {
        Assert.assertThat((Object)ValueType.extractType((String)"", (String)""), (Matcher)Matchers.is((Object)"quantity"));
    }

    @Test
    public void when_datasetIdWithoutTypePrefix_then_extractDefaultFallback() {
        Assert.assertThat((Object)ValueType.extractType((String)"text234"), (Matcher)Matchers.is((Object)"quantity"));
    }

    @Test
    public void when_datasetIdAndFallback_then_extractDatasetType() {
        Assert.assertThat((Object)ValueType.extractType((String)"text_234", (String)"count"), (Matcher)Matchers.is((Object)"text"));
    }

    @Test
    public void when_datasetIdWithoutTypePrefixAndFallback_then_extractFallback() {
        Assert.assertThat((Object)ValueType.extractType((String)"http://foobar/234", (String)"count"), (Matcher)Matchers.is((Object)"count"));
    }

    @Test
    public void when_datasetId_then_extractDatasetType() {
        Assert.assertThat((Object)ValueType.extractType((String)"text_234"), (Matcher)Matchers.is((Object)"text"));
    }

    @Test
    public void when_datasetId_then_extractId() {
        Assert.assertThat((Object)ValueType.extractId((String)"text_234"), (Matcher)Matchers.is((Object)"234"));
    }

    @Test
    public void when_createIdDatasetId_then_typeAndIdGetsConcatenated() {
        Assert.assertThat((Object)ValueType.createId((String)"mytype", (String)"123"), (Matcher)Matchers.is((Object)"mytype_123"));
    }

    @Test
    public void when_createIdWithCamelCasedType_then_typeGetsLowercased() {
        Assert.assertThat((Object)ValueType.createId((String)"myType", (String)"123"), (Matcher)Matchers.is((Object)"mytype_123"));
    }

    @Test
    public void when_createIdWithCamelCasedId_then_idKeepsCamelCased() {
        Assert.assertThat((Object)ValueType.createId((String)"mytype", (String)"camelCasedId"), (Matcher)Matchers.is((Object)"mytype_camelCasedId"));
    }

    @Test
    public void when_createWithNullType_then_returnIdentity() {
        Assert.assertThat((Object)ValueType.createId(null, (String)"123"), (Matcher)Matchers.is((Object)"123"));
    }

    @Test
    public void when_createWithEmptyType_then_returnIdentity() {
        Assert.assertThat((Object)ValueType.createId((String)"", (String)"123"), (Matcher)Matchers.is((Object)"123"));
    }

    @Test
    public void when_createWithEmptyId_then_throwException() {
        this.thrown.expect(IllegalArgumentException.class);
        ValueType.createId((String)"myType", (String)"");
    }

    @Test
    public void when_createWithNullId_then_throwException() {
        this.thrown.expect(NullPointerException.class);
        ValueType.createId((String)"myType", null);
    }
}

