/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.crs;

import com.vividsolutions.jts.geom.Point;
import java.io.Serializable;
import org.n52.io.crs.CRSUtils;

public class BoundingBox
implements Serializable {
    private static final long serialVersionUID = -674668726920006020L;
    private Point ll;
    private Point ur;
    private String srs;

    private BoundingBox() {
    }

    public BoundingBox(Point ll, Point ur, String srs) {
        this.ll = ll;
        this.ur = ur;
        this.srs = srs;
    }

    public boolean contains(Point point) {
        return this.isWithinXRange(point.getX()) && this.isWithinYRange(point.getY());
    }

    public void extendBy(Point point) {
        if (!this.contains(point)) {
            CRSUtils crsUtils = CRSUtils.createEpsgForcedXYAxisOrder();
            this.ll = crsUtils.createPoint(Math.min(point.getX(), this.ll.getX()), Math.max(point.getX(), this.ur.getX()), this.srs);
            this.ur = crsUtils.createPoint(Math.min(point.getY(), this.ll.getY()), Math.max(point.getY(), this.ur.getY()), this.srs);
        }
    }

    private boolean isWithinXRange(double x) {
        return this.ll.getX() <= x && x <= this.ur.getX();
    }

    private boolean isWithinYRange(double y) {
        return this.ll.getY() <= y && y <= this.ur.getY();
    }

    public void setLl(Point ll) {
        this.ll = ll;
    }

    public void setUr(Point ur) {
        this.ur = ur;
    }

    public Point getLowerLeft() {
        return this.ll;
    }

    public Point getUpperRight() {
        return this.ur;
    }

    public String getSrs() {
        return this.srs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BBOX [ (");
        sb.append(this.ll.getX()).append(",").append(this.ll.getY()).append(");(");
        sb.append(this.ur.getX()).append(",").append(this.ur.getY()).append(") ");
        sb.append("srs: ").append(this.getSrs());
        return sb.append(" ]").toString();
    }
}

