/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.geojson;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class GeoJSONObject {
    public static final String LABEL = "label";
    private GeoJSONType type;
    @JsonSerialize(keyAs=String.class, contentAs=Object.class)
    private Map<String, Object> members = new HashMap<String, Object>();

    public GeoJSONObject(String type) {
        this.type = GeoJSONType.valueOf(type);
    }

    @JsonIgnore
    public Object getProperty(String key) {
        return this.members.get(key);
    }

    public boolean hasProperty(String key) {
        return this.members.containsKey(key);
    }

    public Map<String, Object> getMembers() {
        return Collections.unmodifiableMap(this.members);
    }

    public void setMembers(Map<String, Object> members) {
        this.members = members;
    }

    public void setType(String type) {
        this.type = GeoJSONType.valueOf(type);
    }

    public String getType() {
        return this.type.name();
    }

    public static enum GeoJSONType {
        Feature,
        FeatureCollection;

    }
}

