/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.request;

import java.util.Set;
import org.n52.io.request.IoParameters;

public class FilterResolver {
    private final IoParameters parameters;

    public FilterResolver(IoParameters parameters) {
        this.parameters = parameters;
    }

    boolean shallBehaveBackwardsCompatible() {
        return !this.isSetPlatformTypeFilter() && !this.isSetDatasetTypeFilter();
    }

    public boolean shallIncludeMobilePlatformTypes() {
        return this.shallIncludeAllPlatformTypes() || this.isSetMobileFilter() || !this.isSetStationaryFilter();
    }

    public boolean shallIncludeStationaryPlatformTypes() {
        return this.shallIncludeAllPlatformTypes() || this.isSetStationaryFilter() || !this.isSetMobileFilter();
    }

    public boolean shallIncludeInsituPlatformTypes() {
        return this.shallIncludeAllPlatformTypes() || this.isSetInsituFilter() || !this.isSetRemoteFilter();
    }

    public boolean shallIncludeRemotePlatformTypes() {
        return this.shallIncludeAllPlatformTypes() || this.isSetRemoteFilter() || !this.isSetInsituFilter();
    }

    public boolean isSetStationaryFilter() {
        return this.getPlatformTypes().contains("stationary") || this.getPlatformTypes().contains("all");
    }

    public boolean isSetMobileFilter() {
        return this.getPlatformTypes().contains("mobile") || this.getPlatformTypes().contains("all");
    }

    public boolean isSetInsituFilter() {
        return this.getPlatformTypes().contains("insitu") || this.getPlatformTypes().contains("all");
    }

    public boolean isSetRemoteFilter() {
        return this.getPlatformTypes().contains("remote") || this.getPlatformTypes().contains("all");
    }

    public boolean shallIncludeAllPlatformTypes() {
        return !this.isSetPlatformTypeFilter() || this.getPlatformTypes().contains("all");
    }

    public boolean isSetPlatformTypeFilter() {
        return !this.getPlatformTypes().isEmpty();
    }

    private boolean shallIncludeAllPlatformGeometries() {
        return !this.isSetPlatformGeometriesFilter() || this.getPlatformGeometryTypes().contains("all");
    }

    private boolean isSetPlatformGeometriesFilter() {
        return !this.getPlatformGeometryTypes().isEmpty();
    }

    private boolean shallIncludeAllObservedGeometries() {
        return !this.isSetObservedGeometriesFilter() || this.getObservedGeometryTypes().contains("all");
    }

    private boolean isSetObservedGeometriesFilter() {
        return !this.getObservedGeometryTypes().isEmpty();
    }

    public boolean shallIncludePlatformGeometriesSite() {
        return this.shallIncludeAllPlatformGeometries() && this.shallIncludeAllPlatformTypes() && !this.isSetObservedGeometriesFilter() && !this.isSetMobileFilter() && !this.isSetRemoteFilter() || this.isSetStationaryFilter() || this.isSetInsituFilter() || this.isSetSiteFilter();
    }

    private boolean isSetSiteFilter() {
        return this.getPlatformGeometryTypes().contains("site");
    }

    public boolean shallIncludePlatformGeometriesTrack() {
        return this.shallIncludeAllPlatformGeometries() && this.shallIncludeAllPlatformTypes() && !this.isSetObservedGeometriesFilter() && !this.isSetStationaryFilter() && !this.isSetRemoteFilter() || this.isSetMobileFilter() || this.isSetInsituFilter() || this.isSetTrackFilter();
    }

    private boolean isSetTrackFilter() {
        return this.getPlatformGeometryTypes().contains("track");
    }

    public boolean shallIncludeObservedGeometriesStatic() {
        return this.shallIncludeAllObservedGeometries() && this.shallIncludeAllPlatformTypes() || this.isSetStaticFilter() || !this.isSetDynamicFilter() && !this.isSetInsituFilter();
    }

    private boolean isSetStaticFilter() {
        return this.getObservedGeometryTypes().contains("static") || this.getObservedGeometryTypes().contains("all");
    }

    public boolean shallIncludeObservedGeometriesDynamic() {
        return this.shallIncludeAllObservedGeometries() && this.shallIncludeAllPlatformTypes() || this.isSetDynamicFilter() || !this.isSetStaticFilter() && !this.isSetInsituFilter();
    }

    private boolean isSetDynamicFilter() {
        return this.getObservedGeometryTypes().contains("dynamic") || this.getObservedGeometryTypes().contains("all");
    }

    private Set<String> getPlatformTypes() {
        return this.parameters.getPlatformTypes();
    }

    private Set<String> getObservedGeometryTypes() {
        return this.parameters.getObservedGeometryTypes();
    }

    private Set<String> getPlatformGeometryTypes() {
        return this.parameters.getPlatformGeometryTypes();
    }

    public boolean shallIncludeAllDatasetTypes() {
        Set<String> datasetTypes = this.parameters.getValueTypes();
        return !this.isSetDatasetTypeFilter() || datasetTypes.contains("all");
    }

    public boolean shallIncludeDatasetType(String datasetType) {
        Set<String> datasetTypes = this.parameters.getValueTypes();
        return datasetTypes.contains(datasetType) || datasetTypes.contains("all");
    }

    private boolean isSetDatasetTypeFilter() {
        return !this.parameters.getValueTypes().isEmpty();
    }
}

