/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTimeZone;
import org.n52.io.IntervalWithTimeZone;
import org.n52.io.request.IoParameters;
import org.n52.io.response.dataset.ValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class RequestParameterSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestParameterSet.class);
    private static final String PARAMETER_RESULT_TIME = "resultTime";
    private static final String DEFAULT_TIMEZONE = "UTC";
    private static final String DEFAULT_LOCALE = "en";
    private final Map<String, JsonNode> parameters = new HashMap<String, JsonNode>();

    protected RequestParameterSet() {
        IntervalWithTimeZone defaultTimespan = IoParameters.createDefaultTimespan();
        this.parameters.put("timespan", IoParameters.getJsonNodeFrom(defaultTimespan));
    }

    public String getOutputTimezone() {
        return this.getAsString("outputTimezone", DEFAULT_TIMEZONE);
    }

    public void setOutputTimezone(String timezone) {
        Set availableIDs = DateTimeZone.getAvailableIDs();
        DateTimeZone zone = availableIDs.contains(timezone) ? DateTimeZone.forID((String)timezone) : DateTimeZone.UTC;
        this.setParameter("outputTimezone", IoParameters.getJsonNodeFrom(zone.getID()));
    }

    public boolean isGeneralize() {
        return this.getAsBoolean("generalize", false);
    }

    public void setGeneralize(boolean generalize) {
        this.setParameter("generalize", IoParameters.getJsonNodeFrom(generalize));
    }

    @JsonProperty
    public String getTimespan() {
        return this.getAsString("timespan");
    }

    public void setTimespan(String timespan) {
        IntervalWithTimeZone nonNullTimespan = timespan == null ? IoParameters.createDefaultTimespan() : this.validateTimespan(timespan);
        this.setParameter("timespan", IoParameters.getJsonNodeFrom(nonNullTimespan.toString()));
    }

    public boolean isBase64() {
        return this.getAsBoolean("base64", false);
    }

    public void setBase64(boolean base64) {
        this.setParameter("base64", IoParameters.getJsonNodeFrom(base64));
    }

    public boolean isExpanded() {
        return this.getAsBoolean("expanded", false);
    }

    @Deprecated
    public String getLanguage() {
        return this.getAsString("language", DEFAULT_LOCALE);
    }

    @Deprecated
    public void setLanguage(String language) {
        String nonNullLanguage = language != null && !language.isEmpty() ? language : DEFAULT_LOCALE;
        this.setParameter("language", IoParameters.getJsonNodeFrom(nonNullLanguage));
    }

    public void setExpanded(boolean expanded) {
        this.setParameter("expanded", IoParameters.getJsonNodeFrom(expanded));
    }

    public String getLocale() {
        return this.getAsString("locale");
    }

    public void setLocale(String locale) {
        String nonNullLanguage = locale != null && !locale.isEmpty() ? locale : DEFAULT_LOCALE;
        this.setParameter("locale", IoParameters.getJsonNodeFrom(nonNullLanguage));
    }

    public String getResultTime() {
        return this.getAsString(PARAMETER_RESULT_TIME);
    }

    public void setResultTime(String resultTime) {
        if (resultTime != null) {
            this.setParameter(PARAMETER_RESULT_TIME, IoParameters.getJsonNodeFrom(resultTime));
        }
    }

    private IntervalWithTimeZone validateTimespan(String timespan) {
        return new IntervalWithTimeZone(timespan);
    }

    public Set<String> availableParameterNames() {
        return Collections.unmodifiableSet(this.parameters.keySet());
    }

    public final boolean containsParameter(String parameter) {
        String lowerCasedParameter = parameter.toLowerCase();
        return this.parameters.containsKey(lowerCasedParameter) && this.parameters.get(lowerCasedParameter) != null;
    }

    public void removeParameter(String parameterName) {
        if (parameterName != null && !parameterName.isEmpty()) {
            this.parameters.remove(parameterName.toLowerCase());
        }
    }

    public final void setParameters(Map<String, JsonNode> parameters) {
        if (parameters != null) {
            this.parameters.clear();
            for (Map.Entry<String, JsonNode> entry : parameters.entrySet()) {
                this.setParameter(entry.getKey(), entry.getValue());
            }
        }
    }

    public final void setParameter(String parameter, Object value) {
        this.setParameter(parameter, IoParameters.getJsonNodeFrom(value));
    }

    public final void setParameter(String parameterName, JsonNode value) {
        this.parameters.put(parameterName.toLowerCase(), value);
    }

    public final <T> T getAs(Class<T> clazz, String parameterName, T defaultValue) {
        try {
            if (!this.parameters.containsKey(parameterName.toLowerCase())) {
                return defaultValue;
            }
            ObjectMapper om = new ObjectMapper();
            return (T)om.treeToValue((TreeNode)this.getParameterValue(parameterName), clazz);
        }
        catch (IOException e) {
            LOGGER.error("No appropriate config for parameter '{}'.", (Object)parameterName, (Object)e);
            return null;
        }
    }

    public final <T> T getAs(Class<T> clazz, String parameterName) {
        return this.getAs(clazz, parameterName, null);
    }

    public final JsonNode getParameterValue(String parameterName) {
        return this.parameters.get(parameterName.toLowerCase());
    }

    public final String[] getAsStringArray(String parameterName) {
        return this.getAsStringArray(parameterName, null);
    }

    public final String[] getAsStringArray(String parameterName, String[] defaultValue) {
        String[] stringArray;
        if (!this.parameters.containsKey(parameterName.toLowerCase())) {
            return defaultValue;
        }
        JsonNode parameterValue = this.getParameterValue(parameterName);
        if (parameterValue.isArray()) {
            stringArray = this.getAs(String[].class, parameterName, defaultValue);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.getAsString(parameterName);
        }
        return stringArray;
    }

    public final String getAsString(String parameterName) {
        return this.getAsString(parameterName, null);
    }

    public final String getAsString(String parameterName, String defaultValue) {
        return this.parameters.containsKey(parameterName.toLowerCase()) ? this.getParameterValue(parameterName).asText() : defaultValue;
    }

    public final Integer getAsInt(String parameterName) {
        return this.getAsInt(parameterName, null);
    }

    public final Integer getAsInt(String parameterName, Integer defaultValue) {
        return this.parameters.containsKey(parameterName.toLowerCase()) ? Integer.valueOf(this.getParameterValue(parameterName).asInt()) : defaultValue;
    }

    public final Boolean getAsBoolean(String parameterName) {
        return this.getAsBoolean(parameterName, null);
    }

    public final Boolean getAsBoolean(String parameterName, Boolean defaultValue) {
        return this.parameters.containsKey(parameterName.toLowerCase()) ? Boolean.valueOf(this.getParameterValue(parameterName).asBoolean()) : defaultValue;
    }

    public abstract String[] getDatasets();

    @Deprecated
    public String[] getTimeseriesIds() {
        return this.getDatasets();
    }

    public String getValueType() {
        String handleAs = this.getAsString("handleAs");
        String[] datasetIds = this.getDatasets();
        return datasetIds.length > 0 ? ValueType.extractType(datasetIds[0], handleAs) : "quantity";
    }

    public IoParameters toParameters() {
        return IoParameters.createFromSingleJsonValueMap(this.parameters).replaceWith("datasets", this.getDatasets());
    }

    public String toString() {
        return "RequestParameterSet{parameters=" + this.parameters + '}';
    }
}

