/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.request;

import com.vividsolutions.jts.geom.Point;
import org.n52.io.crs.BoundingBox;
import org.n52.io.crs.CRSUtils;
import org.n52.io.crs.WGS84Util;
import org.n52.io.geojson.old.GeojsonPoint;
import org.opengis.referencing.FactoryException;

public class Vicinity {
    private String crs = "CRS:84";
    private GeojsonPoint center;
    private double radius;

    Vicinity() {
    }

    public Vicinity(GeojsonPoint center, String radius) {
        try {
            this.radius = Double.parseDouble(radius);
            this.center = center;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Could not parse radius.");
        }
    }

    public BoundingBox calculateBounds() {
        return this.calculateBounds(CRSUtils.createEpsgStrictAxisOrder());
    }

    public BoundingBox calculateBounds(CRSUtils crsUtils) {
        Point point = this.createPoint(this.center, crsUtils);
        double latInRad = Math.toRadians(point.getY());
        double latitudeDelta = WGS84Util.getLatitudeDelta(this.radius);
        double longitudeDelta = WGS84Util.getLongitudeDelta(latInRad, this.radius);
        double llEasting = WGS84Util.normalizeLongitude(point.getX() - longitudeDelta);
        double llNorthing = WGS84Util.normalizeLatitude(point.getY() - latitudeDelta);
        double urEasting = WGS84Util.normalizeLongitude(point.getX() + longitudeDelta);
        double urNorthing = WGS84Util.normalizeLatitude(point.getY() + latitudeDelta);
        try {
            if (crsUtils.isLatLonAxesOrder(this.crs)) {
                Point ll = crsUtils.createPoint(llNorthing, llEasting, this.crs);
                Point ur = crsUtils.createPoint(urNorthing, urEasting, this.crs);
                return new BoundingBox(ll, ur, this.crs);
            }
            Point ll = crsUtils.createPoint(llEasting, llNorthing, this.crs);
            Point ur = crsUtils.createPoint(urEasting, urNorthing, this.crs);
            return new BoundingBox(ll, ur, this.crs);
        }
        catch (FactoryException e) {
            throw new IllegalStateException("Illegal CRS parameter: " + this.crs, e);
        }
    }

    private Point createPoint(GeojsonPoint point, CRSUtils crsUtils) {
        Double easting = point.getCoordinates()[0];
        Double northing = point.getCoordinates()[1];
        return crsUtils.createPoint(easting, northing, "CRS:84");
    }

    public void setCrs(String crs) {
        if (crs != null) {
            this.crs = crs;
        }
    }

    public void setCenter(GeojsonPoint center) {
        this.center = center;
    }

    public GeojsonPoint getCenter() {
        return this.center;
    }

    public void setRadius(String radius) {
        this.radius = Double.parseDouble(radius);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append(" [ ");
        sb.append("Center: ").append(this.center).append(", ");
        sb.append("Radius: ").append(this.radius).append(" km");
        return sb.append(" ]").toString();
    }
}

