/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.response;

import java.util.Optional;

public final class OptionalOutput<T> {
    private Optional<T> value;
    private boolean serialize;

    private OptionalOutput(T value, boolean serialize) {
        this.value = Optional.ofNullable(value);
        this.serialize = serialize;
    }

    public static <T> OptionalOutput<T> of(T value) {
        return OptionalOutput.of(value, true);
    }

    public static <T> OptionalOutput<T> of(T value, boolean serialize) {
        return new OptionalOutput<T>(value, serialize);
    }

    public boolean isSerialize() {
        return this.serialize;
    }

    public boolean isPresent() {
        return this.value.isPresent();
    }

    public boolean isAbsent() {
        return !this.value.isPresent();
    }

    public T getValue() {
        return this.getValue(false);
    }

    public T getValue(boolean forced) {
        return (T)(forced || this.isSerialize() ? this.value.get() : null);
    }
}

