/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.text.Collator;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.n52.io.request.IoParameters;
import org.n52.io.response.CollatorComparable;
import org.n52.io.response.OptionalOutput;
import org.n52.series.spi.srv.RawFormats;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class ParameterOutput
implements CollatorComparable<ParameterOutput>,
RawFormats {
    public static final String ID = "id";
    public static final String HREF = "href";
    public static final String HREF_BASE = "href";
    public static final String DOMAIN_ID = "domainid";
    public static final String LABEL = "label";
    public static final String EXTRAS = "extras";
    public static final String RAWFORMATS = "service";
    private String id;
    private OptionalOutput<String> href;
    private OptionalOutput<String> hrefBase;
    private OptionalOutput<String> domainId;
    private OptionalOutput<String> label;
    @Deprecated
    private OptionalOutput<String> license;
    private OptionalOutput<Collection<String>> extras;
    private OptionalOutput<Set<String>> rawFormats;

    public <T> void setValue(String parameter, T value, IoParameters parameters, Consumer<OptionalOutput<T>> consumer) {
        Set<String> fields = parameters.getFields();
        boolean serialize = fields.isEmpty() || fields.contains(parameter);
        consumer.accept(OptionalOutput.of(value, serialize));
    }

    protected <T> T getIfSerialized(OptionalOutput<T> optional) {
        return this.getIfSet(optional, false);
    }

    protected <T extends Collection<E>, E> T getIfSerializedCollection(OptionalOutput<T> optional) {
        return this.getIfSetCollection(optional, false);
    }

    protected <K, T> Map<K, T> getIfSerializedMap(OptionalOutput<Map<K, T>> optional) {
        return this.getIfSetMap(optional, false);
    }

    protected <T> T getIfSet(OptionalOutput<T> optional, boolean forced) {
        return this.isSet(optional) ? (T)optional.getValue(forced) : null;
    }

    protected <T extends Collection<E>, E> T getIfSetCollection(OptionalOutput<T> optional, boolean forced) {
        return (T)(this.resolvesToNonNullValue(optional) && !((Collection)optional.getValue()).isEmpty() ? (Collection)optional.getValue(forced) : null);
    }

    protected <K, T> Map<K, T> getIfSetMap(OptionalOutput<Map<K, T>> optional, boolean forced) {
        return this.resolvesToNonNullValue(optional) && !optional.getValue().isEmpty() ? optional.getValue(forced) : null;
    }

    protected <T> boolean isSet(OptionalOutput<T> optional) {
        return optional != null && optional.isPresent();
    }

    protected <T> boolean resolvesToNonNullValue(OptionalOutput<T> optional) {
        return this.isSet(optional) && optional.isSerialize();
    }

    public String getId() {
        return this.id;
    }

    public ParameterOutput setId(String id) {
        this.id = id;
        return this;
    }

    public String getHref() {
        if (this.getHrefBase() == null && this.href == null) {
            return null;
        }
        return !this.isSet(this.href) && this.getHrefBase() != null ? this.getHrefBase() + "/" + this.getId() : this.href.getValue();
    }

    public ParameterOutput setHref(OptionalOutput<String> href) {
        this.href = href;
        return this;
    }

    @JsonIgnore
    public String getHrefBase() {
        return this.getIfSerialized(this.hrefBase);
    }

    public ParameterOutput setHrefBase(OptionalOutput<String> hrefBase) {
        this.hrefBase = hrefBase;
        return this;
    }

    public String getDomainId() {
        return this.getIfSerialized(this.domainId);
    }

    public ParameterOutput setDomainId(OptionalOutput<String> domainId) {
        this.domainId = domainId;
        return this;
    }

    public String getLabel() {
        return this.getIfSerialized(this.label);
    }

    public ParameterOutput setLabel(OptionalOutput<String> label) {
        this.label = label;
        return this;
    }

    @Deprecated
    public String getLicense() {
        return this.getIfSerialized(this.license);
    }

    @Deprecated
    public ParameterOutput setLicense(OptionalOutput<String> license) {
        this.license = license;
        return this;
    }

    public Collection<String> getExtras() {
        return this.getIfSerializedCollection(this.extras);
    }

    public ParameterOutput setExtras(OptionalOutput<Collection<String>> extras) {
        this.extras = extras;
        return this;
    }

    @Override
    public Set<String> getRawFormats() {
        return this.getIfSerializedCollection(this.rawFormats);
    }

    @Override
    public ParameterOutput setRawFormats(OptionalOutput<Set<String>> formats) {
        this.rawFormats = formats;
        return this;
    }

    @Override
    public int compare(Collator collator, ParameterOutput o) {
        String thisLabel = this.getLabel();
        String otherLabel = o.getLabel();
        return collator.compare(thisLabel.toLowerCase(), otherLabel.toLowerCase());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.domainId, this.label);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ParameterOutput)) {
            return false;
        }
        ParameterOutput other = (ParameterOutput)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.domainId, other.domainId) && Objects.equals(this.label, other.label);
    }

    public static <T extends ParameterOutput> Comparator<T> defaultComparator() {
        return (o1, o2) -> {
            Comparator nullsFirst = Comparator.nullsFirst(Comparator.naturalOrder());
            return Comparator.comparing(ParameterOutput::getLabel, nullsFirst).thenComparing(ParameterOutput::getId).compare((ParameterOutput)o1, (ParameterOutput)o2);
        };
    }
}

