/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.vividsolutions.jts.geom.Geometry;
import java.util.Collection;
import org.n52.io.geojson.GeoJSONGeometrySerializer;
import org.n52.io.response.OptionalOutput;
import org.n52.io.response.OutputWithParameters;
import org.n52.io.response.PlatformType;
import org.n52.io.response.dataset.DatasetOutput;

public class PlatformOutput
extends OutputWithParameters {
    public static final String DATASETS = "datasets";
    public static final String GEOMETRY = "geometry";
    public static final String PLATFORMTYPE = "platformtype";
    private OptionalOutput<PlatformType> platformType;
    private OptionalOutput<Collection<DatasetOutput>> datasets;
    private OptionalOutput<Geometry> geometry;

    @Override
    public String getHrefBase() {
        String base = super.getHrefBase();
        String suffix = this.getType().getPlatformType();
        return base != null && base.endsWith(suffix) ? base.substring(0, base.lastIndexOf(suffix) - 1) : base;
    }

    public String getPlatformType() {
        if (this.getIfSerialized(this.platformType) != null) {
            return this.getType().getPlatformType();
        }
        return null;
    }

    public PlatformOutput setPlatformType(OptionalOutput<PlatformType> platformtype) {
        this.platformType = platformtype;
        return this;
    }

    @JsonIgnore
    public PlatformType getType() {
        PlatformType type = this.getIfSet(this.platformType, true);
        return type != null ? type : PlatformType.STATIONARY_INSITU;
    }

    @Override
    public PlatformOutput setId(String id) {
        if (this.getType() != null) {
            super.setId(this.getType().createId(id));
        }
        return this;
    }

    public Collection<DatasetOutput> getDatasets() {
        return this.getIfSerializedCollection(this.datasets);
    }

    public PlatformOutput setDatasets(OptionalOutput<Collection<DatasetOutput>> series) {
        this.datasets = series;
        return this;
    }

    @JsonSerialize(using=GeoJSONGeometrySerializer.class)
    public Geometry getGeometry() {
        return this.getIfSerialized(this.geometry);
    }

    public PlatformOutput setGeometry(OptionalOutput<Geometry> geometry) {
        this.geometry = geometry;
        return this;
    }
}

