/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.response;

import java.util.Map;
import java.util.Objects;
import org.n52.io.Utils;
import org.n52.io.response.OptionalOutput;
import org.n52.io.response.ParameterOutput;

public class ServiceOutput
extends ParameterOutput {
    public static final String SERVICE_URL = "serviceurl";
    public static final String VERSION = "version";
    public static final String TYPE = "type";
    public static final String FEATURES = "features";
    public static final String QUANTITIES = "quantities";
    public static final String SUPPORTS_FIRST_LATEST = "supportsfirstlatest";
    public static final String SUPPORTED_MIME_TYPES = "supportedmimetypes";
    private OptionalOutput<String> serviceUrl;
    private OptionalOutput<String> version;
    private OptionalOutput<String> type;
    private OptionalOutput<ParameterCount> quantities;
    @Deprecated
    private OptionalOutput<Boolean> supportsFirstLatest;

    public String getServiceUrl() {
        return this.getIfSerialized(this.serviceUrl);
    }

    public void setServiceUrl(OptionalOutput<String> serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public String getVersion() {
        return this.getIfSerialized(this.version);
    }

    public void setVersion(OptionalOutput<String> version) {
        this.version = version;
    }

    public String getType() {
        return this.getIfSerialized(this.type);
    }

    public void setType(OptionalOutput<String> type) {
        this.type = type;
    }

    public void setFeatures(OptionalOutput<Map<String, Object>> features) {
        if (features != null && features.isPresent()) {
            this.checkForContent(features.getValue());
        }
    }

    private void checkForContent(Map<String, Object> value) {
        if (value.containsKey(QUANTITIES)) {
            this.setQuantities(OptionalOutput.of((ParameterCount)value.get(QUANTITIES)));
        }
        if (value.containsKey(SUPPORTS_FIRST_LATEST)) {
            this.setSupportsFirstLatest(OptionalOutput.of((Boolean)value.get(SUPPORTS_FIRST_LATEST)));
        }
    }

    @Deprecated
    public Boolean isSupportsFirstLatest() {
        return this.getIfSerialized(this.supportsFirstLatest);
    }

    @Deprecated
    public void setSupportsFirstLatest(OptionalOutput<Boolean> supportsFirstLatest) {
        this.supportsFirstLatest = supportsFirstLatest;
    }

    @Deprecated
    public void setQuantities(OptionalOutput<ParameterCount> quantities) {
        this.quantities = quantities;
    }

    @Deprecated
    public ParameterCount getQuantities() {
        return this.getIfSerialized(this.quantities);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.serviceUrl, this.version, this.type);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ServiceOutput)) {
            return false;
        }
        ServiceOutput other = (ServiceOutput)obj;
        return Objects.equals(this.serviceUrl, other.serviceUrl) && Objects.equals(this.version, other.version) && Objects.equals(this.type, other.type) && super.equals(other);
    }

    public static class ParameterCount {
        private String[] selectedPlatformTypes;
        private Integer amountOfferings;
        private Integer amountFeatures;
        private Integer amountProcedures;
        private Integer amountPhenomena;
        private Integer amountCategories;
        private Integer amountPlatforms;
        private Integer amountDatasets;
        @Deprecated
        private Integer amountStations;
        @Deprecated
        private Integer amountTimeseries;

        public String[] getSelectedPlatformTypes() {
            return Utils.copy(this.selectedPlatformTypes);
        }

        public void setSelectedPlatformTypes(String ... selectedPlatformTypes) {
            this.selectedPlatformTypes = selectedPlatformTypes;
        }

        public Integer getOfferings() {
            return this.amountOfferings;
        }

        public void setOfferingsSize(Integer size) {
            this.amountOfferings = size;
        }

        public Integer getFeatures() {
            return this.amountFeatures;
        }

        public void setFeaturesSize(Integer size) {
            this.amountFeatures = size;
        }

        public Integer getProcedures() {
            return this.amountProcedures;
        }

        public void setProceduresSize(Integer size) {
            this.amountProcedures = size;
        }

        public Integer getPhenomena() {
            return this.amountPhenomena;
        }

        public void setPhenomenaSize(Integer size) {
            this.amountPhenomena = size;
        }

        public Integer getCategories() {
            return this.amountCategories;
        }

        public void setCategoriesSize(Integer size) {
            this.amountCategories = size;
        }

        public Integer getPlatforms() {
            return this.amountPlatforms;
        }

        public void setPlatformsSize(Integer size) {
            this.amountPlatforms = size;
        }

        public Integer getDatasets() {
            return this.amountDatasets;
        }

        public void setDatasetsSize(Integer size) {
            this.amountDatasets = size;
        }

        @Deprecated
        public Integer getStations() {
            return this.amountStations;
        }

        @Deprecated
        public void setStationsSize(int size) {
            this.amountStations = size;
        }

        @Deprecated
        public void setTimeseriesSize(int countTimeseries) {
            this.amountTimeseries = countTimeseries;
        }

        @Deprecated
        public Integer getTimeseries() {
            return this.amountTimeseries;
        }
    }
}

