/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.response.dataset;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.DatasetMetadata;

public class Data<T extends AbstractValue<?>>
implements Serializable {
    private static final long serialVersionUID = 3119211667773416585L;
    private List<T> values = new ArrayList<T>();
    private DatasetMetadata<Data<T>> metadata;

    public void addValues(T ... toAdd) {
        if (toAdd != null && toAdd.length > 0) {
            this.values.addAll(Arrays.asList(toAdd));
        }
    }

    public void setValues(T[] values) {
        this.values = Arrays.asList(values);
    }

    public List<T> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public void addNewValue(T value) {
        this.values.add(value);
    }

    public long size() {
        return this.values.size();
    }

    @JsonIgnore
    public boolean hasReferenceValues() {
        return this.getMetadata() != null && this.getMetadata().hasReferenceValues();
    }

    public void setMetadata(DatasetMetadata<Data<T>> metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="extra")
    public DatasetMetadata<Data<T>> getMetadata() {
        return this.metadata;
    }
}

