/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.response.dataset;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.n52.io.request.IoParameters;
import org.n52.io.response.OptionalOutput;
import org.n52.io.response.ParameterOutput;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.DatasetParameters;
import org.n52.io.response.dataset.ReferenceValueOutput;
import org.n52.io.response.dataset.ValueType;

public class DatasetOutput<V extends AbstractValue<?>>
extends ParameterOutput {
    public static final String VALUE_TYPE = "valuetype";
    public static final String PLATFORM_TYPE = "platformtype";
    public static final String DATASET_PARAMETERS = "parameters";
    public static final String REFERENCE_VALUES = "referencevalues";
    public static final String FIRST_VALUE = "firstvalue";
    public static final String LAST_VALUE = "lastvalue";
    public static final String UOM = "uom";
    private OptionalOutput<String> valueType;
    private OptionalOutput<String> platformType;
    private OptionalOutput<DatasetParameters> datasetParameters;
    private OptionalOutput<List<ReferenceValueOutput<V>>> referenceValues;
    private OptionalOutput<V> firstValue;
    private OptionalOutput<V> lastValue;
    private OptionalOutput<String> uom;

    protected DatasetOutput() {
    }

    public static <V extends AbstractValue<?>> DatasetOutput<V> create(String type, IoParameters params) {
        DatasetOutput<V> output = new DatasetOutput<V>();
        output.setValue(VALUE_TYPE, type, params, output::setValueType);
        return output;
    }

    @Override
    public DatasetOutput<V> setId(String id) {
        String type = this.getIfSet(this.valueType, true);
        super.setId(ValueType.createId(type, id));
        return this;
    }

    public String getValueType() {
        return this.getIfSerialized(this.valueType);
    }

    protected void setValueType(OptionalOutput<String> valueType) {
        this.valueType = valueType;
    }

    public String getPlatformType() {
        return this.getIfSerialized(this.platformType);
    }

    public DatasetOutput<V> setPlatformType(OptionalOutput<String> platformType) {
        this.platformType = platformType;
        return this;
    }

    @JsonProperty(value="parameters")
    public DatasetParameters getDatasetParameters() {
        return this.getDatasetParameters(false);
    }

    public DatasetParameters getDatasetParameters(boolean forced) {
        return this.getIfSet(this.datasetParameters, forced);
    }

    public DatasetOutput<V> setDatasetParameters(OptionalOutput<DatasetParameters> parameters) {
        this.datasetParameters = parameters;
        return this;
    }

    public String getUom() {
        return this.getIfSerialized(this.uom);
    }

    public DatasetOutput<V> setUom(OptionalOutput<String> uom) {
        this.uom = uom;
        return this;
    }

    public V getFirstValue() {
        return (V)((AbstractValue)this.getIfSerialized(this.firstValue));
    }

    public DatasetOutput<V> setFirstValue(OptionalOutput<V> firstValue) {
        this.firstValue = firstValue;
        return this;
    }

    public V getLastValue() {
        return (V)((AbstractValue)this.getIfSerialized(this.lastValue));
    }

    public DatasetOutput<V> setLastValue(OptionalOutput<V> lastValue) {
        this.lastValue = lastValue;
        return this;
    }

    public List<ReferenceValueOutput<V>> getReferenceValues() {
        return this.getIfSerializedCollection(this.referenceValues);
    }

    public DatasetOutput<V> setReferenceValues(OptionalOutput<List<ReferenceValueOutput<V>>> referenceValues) {
        this.referenceValues = referenceValues;
        return this;
    }
}

