/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.response.extension;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.io.FileUtils;
import org.n52.io.request.IoParameters;
import org.n52.io.response.ParameterOutput;
import org.n52.io.response.extension.MetadataExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseExtension
extends MetadataExtension<ParameterOutput> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LicenseExtension.class);
    private static final String CONFIG_FILE = "config-license.txt";
    private static final String EXTENSION_NAME = "license";
    private final String licenseText;

    public LicenseExtension() {
        this(CONFIG_FILE);
    }

    public LicenseExtension(String configFile) {
        this.licenseText = this.readLicenseText(configFile);
    }

    private String readLicenseText(String configFile) {
        try {
            File file;
            Path root = Paths.get(this.getClass().getResource("/").toURI());
            Path target = Paths.get(configFile, new String[0]);
            File file2 = file = !Files.exists(target, new LinkOption[0]) ? root.resolve(configFile).toFile() : target.toFile();
            if (file.exists()) {
                return FileUtils.readFileToString((File)file);
            }
            ClassLoader classLoader = this.getClass().getClassLoader();
            InputStream is = classLoader.getResourceAsStream("/" + configFile);
            if (is == null) {
                LOGGER.error("Could not find license config file '{}'", (Object)file.getPath());
                return "";
            }
            return this.readFromInputStream(is);
        }
        catch (IOException | URISyntaxException e) {
            LOGGER.error("Could not load {}. Using empty license.", (Object)CONFIG_FILE, (Object)e);
            return "";
        }
    }

    private String readFromInputStream(InputStream stream) {
        try (Scanner scanner = new Scanner(stream, "UTF-8");){
            StringBuilder sb = new StringBuilder();
            while (scanner.hasNextLine()) {
                sb.append(scanner.nextLine());
            }
            String string = sb.toString();
            return string;
        }
    }

    @Override
    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    @Override
    public Map<String, Object> getExtras(ParameterOutput output, IoParameters parameters) {
        return this.hasExtrasToReturn(output, parameters) ? this.wrapSingleIntoMap(this.licenseText) : Collections.emptyMap();
    }
}

