/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.style;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public abstract class Style {
    public static final String PARAMETER_COLOR = "color";
    public static final String PARAMETER_INTERVAL = "interval";
    public static final String VALUE_INTERVAL_BY_MONTH = "byMonth";
    public static final String VALUE_INTERVAL_BY_WEEK = "byWeek";
    public static final String VALUE_INTERVAL_BY_DAY = "byDay";
    public static final String VALUE_INTERVAL_BY_HOUR = "byHour";
    private Map<String, String> properties = new HashMap<String, String>();

    public String getColor() {
        if (this.hasProperty(PARAMETER_COLOR)) {
            return this.getPropertyAsString(PARAMETER_COLOR);
        }
        return this.getRandomHexColor();
    }

    private String getRandomHexColor() {
        String redHex = this.getNextFormattedRandomNumber();
        String yellowHex = this.getNextFormattedRandomNumber();
        String blueHex = this.getNextFormattedRandomNumber();
        return "#" + redHex + yellowHex + blueHex;
    }

    private String getNextFormattedRandomNumber() {
        Random random = new Random(System.currentTimeMillis());
        String randomHex = Integer.toHexString(random.nextInt(256));
        if (randomHex.length() == 1) {
            randomHex = "0" + randomHex;
        }
        return randomHex;
    }

    Object getProperty(String property) {
        return this.properties == null ? null : this.properties.get(property);
    }

    String getPropertyAsString(String property) {
        return (String)this.getProperty(property);
    }

    double getPropertyAsDouble(String property) {
        if (this.properties == null) {
            this.throwUnknownPropertyException(property);
        }
        return Double.parseDouble(this.properties.get(property));
    }

    int getPropertyAsInt(String property) {
        if (this.properties == null) {
            this.throwUnknownPropertyException(property);
        }
        return Integer.parseInt(this.properties.get(property));
    }

    boolean getPropertyAsBoolean(String property) {
        if (this.properties == null) {
            this.throwUnknownPropertyException(property);
        }
        return Boolean.parseBoolean(this.properties.get(property));
    }

    Object[] getPropertyAsArray(String property) {
        return (Object[])this.getProperty(property);
    }

    boolean hasProperty(String property) {
        return !this.shallExpectDefault() && this.properties.containsKey(property);
    }

    private boolean shallExpectDefault() {
        return this.properties == null;
    }

    Map<String, String> getProperties() {
        return this.properties;
    }

    void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    private void throwUnknownPropertyException(String property) {
        throw new NullPointerException("No property with name '" + property + "'.");
    }
}

