/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.spi.geo;

import com.vividsolutions.jts.geom.Geometry;
import org.n52.io.request.IoParameters;
import org.n52.io.response.GeometryInfo;
import org.n52.io.response.OutputCollection;
import org.n52.series.spi.geo.TransformationService;
import org.n52.series.spi.srv.ParameterService;

public class TransformingGeometryOutputService
extends ParameterService<GeometryInfo> {
    private final ParameterService<GeometryInfo> composedService;
    private final TransformationService transformationService;

    public TransformingGeometryOutputService(ParameterService<GeometryInfo> toCompose) {
        this.composedService = toCompose;
        this.transformationService = new TransformationService();
    }

    @Override
    public OutputCollection<GeometryInfo> getExpandedParameters(IoParameters query) {
        return this.transform(query, this.composedService.getExpandedParameters(query));
    }

    @Override
    public OutputCollection<GeometryInfo> getCondensedParameters(IoParameters query) {
        return this.transform(query, this.composedService.getCondensedParameters(query));
    }

    @Override
    public OutputCollection<GeometryInfo> getParameters(String[] items, IoParameters query) {
        return this.transform(query, this.composedService.getParameters(items, query));
    }

    @Override
    public GeometryInfo getParameter(String item, IoParameters query) {
        return this.transform(this.composedService.getParameter(item, query), query);
    }

    @Override
    public boolean exists(String id, IoParameters parameters) {
        return this.composedService.exists(id, parameters);
    }

    private OutputCollection<GeometryInfo> transform(IoParameters query, OutputCollection<GeometryInfo> infos) {
        if (infos != null) {
            for (GeometryInfo info : infos) {
                this.transformInline(info, query);
            }
        }
        return infos;
    }

    private GeometryInfo transform(GeometryInfo info, IoParameters parameters) {
        this.transformInline(info, parameters);
        return info;
    }

    private void transformInline(GeometryInfo info, IoParameters parameters) {
        Geometry geometry = this.transformationService.transform(info.getGeometry(), parameters);
        info.setValue("geometry", geometry, parameters, info::setGeometry);
    }
}

