/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.spi.geo;

import com.vividsolutions.jts.geom.Geometry;
import org.n52.io.request.IoParameters;
import org.n52.io.response.OutputCollection;
import org.n52.io.response.PlatformOutput;
import org.n52.series.spi.geo.TransformationService;
import org.n52.series.spi.srv.ParameterService;

public class TransformingPlatformOutputService
extends ParameterService<PlatformOutput> {
    private final ParameterService<PlatformOutput> composedService;
    private final TransformationService transformationService;

    public TransformingPlatformOutputService(ParameterService<PlatformOutput> toCompose) {
        this.composedService = toCompose;
        this.transformationService = new TransformationService();
    }

    @Override
    public OutputCollection<PlatformOutput> getExpandedParameters(IoParameters query) {
        return this.transform(query, this.composedService.getExpandedParameters(query));
    }

    @Override
    public OutputCollection<PlatformOutput> getCondensedParameters(IoParameters query) {
        return this.transform(query, this.composedService.getCondensedParameters(query));
    }

    @Override
    public OutputCollection<PlatformOutput> getParameters(String[] items, IoParameters query) {
        return this.transform(query, this.composedService.getParameters(items, query));
    }

    @Override
    public PlatformOutput getParameter(String item, IoParameters query) {
        return this.transform(query, this.composedService.getParameter(item, query));
    }

    @Override
    public boolean exists(String id, IoParameters parameters) {
        return this.composedService.exists(id, parameters);
    }

    private OutputCollection<PlatformOutput> transform(IoParameters query, OutputCollection<PlatformOutput> platforms) {
        if (platforms != null) {
            for (PlatformOutput platform : platforms) {
                this.transformInline(query, platform);
            }
        }
        return platforms;
    }

    private PlatformOutput transform(IoParameters query, PlatformOutput platform) {
        this.transformInline(query, platform);
        return platform;
    }

    private void transformInline(IoParameters parameters, PlatformOutput platform) {
        Geometry geometry = platform.getGeometry();
        platform.setValue("geometry", this.transformationService.transform(geometry, parameters), parameters, platform::setGeometry);
    }
}

