/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.crs;

import java.awt.RenderingHints;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CRSUtils {
    public static final int EPSG_WGS84 = 4326;
    public static final String DEFAULT_CRS = "CRS:84";
    private static final Logger LOGGER = LoggerFactory.getLogger(CRSUtils.class);
    private static final String EPSG_PREFIX = "EPSG:";
    private static CoordinateReferenceSystem internCrs;
    protected CRSAuthorityFactory crsFactory;

    private CRSUtils(CRSAuthorityFactory crsFactory) {
        try {
            internCrs = CRS.decode((String)DEFAULT_CRS);
            this.crsFactory = crsFactory;
        }
        catch (FactoryException e) {
            throw new IllegalStateException("Could not create intern CRS!", e);
        }
    }

    public Point createPoint(Double x, Double y, String srs) {
        return this.createPoint(x, y, null, srs);
    }

    public Point createPoint(Double x, Double y, Double z, String srs) {
        Coordinate coordinate = z != null && !z.isNaN() ? new Coordinate(x.doubleValue(), y.doubleValue(), z.doubleValue()) : new Coordinate(x.doubleValue(), y.doubleValue());
        GeometryFactory factory = this.createGeometryFactory(srs);
        return factory.createPoint(coordinate);
    }

    public Geometry createLineString(Coordinate[] coordinates, String srs) {
        GeometryFactory factory = this.createGeometryFactory(srs);
        return factory.createLineString(coordinates);
    }

    public GeometryFactory createGeometryFactory() {
        return this.createGeometryFactory(DEFAULT_CRS);
    }

    public GeometryFactory createGeometryFactory(String srsId) {
        PrecisionModel pm = new PrecisionModel(PrecisionModel.FLOATING);
        return srsId == null ? new GeometryFactory(pm) : new GeometryFactory(pm, CRSUtils.getSrsIdFrom(srsId));
    }

    public static int getSrsIdFrom(String srs) {
        return CRSUtils.getSrsIdFromEPSG(CRSUtils.extractSRSCode(srs));
    }

    public static String extractSRSCode(String srs) {
        if (CRSUtils.isSrsUrlDefinition(srs)) {
            return EPSG_PREFIX + srs.substring(srs.lastIndexOf("/") + 1);
        }
        String[] srsParts = srs.split(":");
        return EPSG_PREFIX + srsParts[srsParts.length - 1];
    }

    private static boolean isSrsUrlDefinition(String srs) {
        return srs.startsWith("http");
    }

    public static int getSrsIdFromEPSG(String srs) {
        String[] epsgParts = srs.split(":");
        if (epsgParts.length > 1) {
            return Integer.parseInt(epsgParts[epsgParts.length - 1]);
        }
        return Integer.parseInt(srs);
    }

    public Point transformOuterToInner(Point point, String srcFrame) throws FactoryException, TransformException {
        return (Point)this.transform((Geometry)point, this.getCrsFor(srcFrame), internCrs);
    }

    public Geometry transformOuterToInner(Geometry geometry, String srcFrame) throws FactoryException, TransformException {
        return this.transform(geometry, this.getCrsFor(srcFrame), internCrs);
    }

    public Geometry transformInnerToOuter(Geometry geometry, String destFrame) throws FactoryException, TransformException {
        return this.transform(geometry, internCrs, this.getCrsFor(destFrame));
    }

    public Geometry transform(Geometry geometry, String srcFrame, String destFrame) throws FactoryException, TransformException {
        return this.transform(geometry, this.getCrsFor(srcFrame), this.getCrsFor(destFrame));
    }

    private Geometry transform(Geometry geometry, CoordinateReferenceSystem srs, CoordinateReferenceSystem dest) throws FactoryException, TransformException {
        return this.checkSrid(JTS.transform((Geometry)geometry, (MathTransform)CRS.findMathTransform((CoordinateReferenceSystem)srs, (CoordinateReferenceSystem)dest)), srs, dest);
    }

    private Geometry checkSrid(Geometry geometry, CoordinateReferenceSystem srs, CoordinateReferenceSystem dest) throws FactoryException {
        if (!srs.equals(dest) && CRS.equalsIgnoreMetadata((Object)dest, (Object)this.getCrsFor(DEFAULT_CRS))) {
            geometry.setSRID(4326);
        }
        return geometry;
    }

    public Geometry parseWkt(String wkt) {
        try {
            return new WKTReader().read(wkt);
        }
        catch (ParseException e) {
            LOGGER.error("Invalid WKT '{}'", (Object)wkt, (Object)e);
            return null;
        }
    }

    public boolean isLatLonAxesOrder(String outer) throws FactoryException {
        return this.isAxesSwitched(internCrs, this.getCrsFor(outer));
    }

    private CoordinateReferenceSystem getCrsFor(String authorityCode) throws FactoryException {
        if (authorityCode == null || DEFAULT_CRS.equalsIgnoreCase(authorityCode)) {
            return internCrs;
        }
        return this.crsFactory.createCoordinateReferenceSystem(authorityCode);
    }

    private boolean isAxesSwitched(CoordinateReferenceSystem first, CoordinateReferenceSystem second) {
        CRS.AxisOrder axisOrderFirst = CRS.getAxisOrder((CoordinateReferenceSystem)first);
        CRS.AxisOrder axisOrderSecond = CRS.getAxisOrder((CoordinateReferenceSystem)second);
        if (axisOrderFirst == CRS.AxisOrder.INAPPLICABLE || axisOrderSecond == CRS.AxisOrder.INAPPLICABLE) {
            LOGGER.warn("Could not determine if axes ordering is switched.");
            return false;
        }
        return axisOrderFirst != axisOrderSecond;
    }

    public static CRSUtils createEpsgStrictAxisOrder() {
        Hints hints = new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)false);
        return CRSUtils.createEpsgReferenceHelper(hints);
    }

    public static CRSUtils createEpsgForcedXYAxisOrder() {
        Hints hints = new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)true);
        return CRSUtils.createEpsgReferenceHelper(hints);
    }

    public static CRSUtils createEpsgReferenceHelper(Hints hints) throws IllegalStateException {
        return new CRSUtils(ReferencingFactoryFinder.getCRSAuthorityFactory((String)"EPSG", (Hints)hints));
    }
}

