/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.geojson;

import com.fasterxml.jackson.databind.JsonNode;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.n52.io.geojson.GeoJSONException;

public class GeoJSONDecoder {
    public static final int DIM_2D = 2;
    public static final int DIM_3D = 3;
    private static final String[] SRS_LINK_PREFIXES = new String[]{"http://www.opengis.net/def/crs/EPSG/0/", "http://spatialreference.org/ref/epsg/"};
    private static final String[] SRS_NAME_PREFIXES = new String[]{"urn:ogc:def:crs:EPSG::", "EPSG::", "EPSG:"};
    private static final int DEFAULT_SRID = 4326;
    private static final PrecisionModel DEFAULT_PRECISION_MODEL = new PrecisionModel(PrecisionModel.FLOATING);
    private static final GeometryFactory DEFAULT_GEOMETRY_FACTORY = new GeometryFactory(DEFAULT_PRECISION_MODEL, 4326);

    public Geometry decodeGeometry(JsonNode node) throws GeoJSONException {
        if (node == null || node.isNull() || node.isMissingNode()) {
            return null;
        }
        return this.decodeGeometry(node, DEFAULT_GEOMETRY_FACTORY);
    }

    protected Geometry decodeGeometry(Object o, GeometryFactory parentFactory) throws GeoJSONException {
        if (!(o instanceof JsonNode)) {
            throw new GeoJSONException("Cannot decode " + o);
        }
        JsonNode node = (JsonNode)o;
        String type = this.getType(node);
        GeometryFactory factory = this.getGeometryFactory(node, parentFactory);
        if (type.equals("Point")) {
            return this.decodePoint(node, factory);
        }
        if (type.equals("MultiPoint")) {
            return this.decodeMultiPoint(node, factory);
        }
        if (type.equals("LineString")) {
            return this.decodeLineString(node, factory);
        }
        if (type.equals("MultiLineString")) {
            return this.decodeMultiLineString(node, factory);
        }
        if (type.equals("Polygon")) {
            return this.decodePolygon(node, factory);
        }
        if (type.equals("MultiPolygon")) {
            return this.decodeMultiPolygon(node, factory);
        }
        if (type.equals("GeometryCollection")) {
            return this.decodeGeometryCollection(node, factory);
        }
        throw new GeoJSONException("Unkown geometry type: " + type);
    }

    protected CoordinateArraySequence decodeCoordinates(JsonNode node) throws GeoJSONException {
        if (!node.isArray()) {
            this.throwExpectedArrayException();
        }
        Coordinate[] coordinates = new Coordinate[node.size()];
        for (int i = 0; i < node.size(); ++i) {
            coordinates[i] = this.decodeCoordinate(node.get(i));
        }
        return new CoordinateArraySequence(coordinates);
    }

    protected Polygon decodePolygonCoordinates(JsonNode coordinates, GeometryFactory fac) throws GeoJSONException {
        if (!coordinates.isArray()) {
            this.throwExpectedArrayException();
        }
        if (coordinates.size() < 1) {
            throw new GeoJSONException("missing polygon shell");
        }
        LinearRing shell = fac.createLinearRing((CoordinateSequence)this.decodeCoordinates(coordinates.get(0)));
        LinearRing[] holes = new LinearRing[coordinates.size() - 1];
        for (int i = 1; i < coordinates.size(); ++i) {
            holes[i - 1] = fac.createLinearRing((CoordinateSequence)this.decodeCoordinates(coordinates.get(i)));
        }
        return fac.createPolygon(shell, holes);
    }

    protected MultiLineString decodeMultiLineString(JsonNode node, GeometryFactory fac) throws GeoJSONException {
        JsonNode coordinates = this.requireCoordinates(node);
        LineString[] lineStrings = new LineString[coordinates.size()];
        for (int i = 0; i < coordinates.size(); ++i) {
            JsonNode coords = coordinates.get(i);
            lineStrings[i] = fac.createLineString((CoordinateSequence)this.decodeCoordinates(coords));
        }
        return fac.createMultiLineString(lineStrings);
    }

    protected LineString decodeLineString(JsonNode node, GeometryFactory fac) throws GeoJSONException {
        return fac.createLineString((CoordinateSequence)this.decodeCoordinates(this.requireCoordinates(node)));
    }

    protected MultiPoint decodeMultiPoint(JsonNode node, GeometryFactory fac) throws GeoJSONException {
        return fac.createMultiPoint((CoordinateSequence)this.decodeCoordinates(this.requireCoordinates(node)));
    }

    protected Point decodePoint(JsonNode node, GeometryFactory fac) throws GeoJSONException {
        Coordinate parsed = this.decodeCoordinate(this.requireCoordinates(node));
        return fac.createPoint(parsed);
    }

    protected Polygon decodePolygon(JsonNode node, GeometryFactory fac) throws GeoJSONException {
        JsonNode coordinates = this.requireCoordinates(node);
        return this.decodePolygonCoordinates(coordinates, fac);
    }

    protected MultiPolygon decodeMultiPolygon(JsonNode node, GeometryFactory fac) throws GeoJSONException {
        JsonNode coordinates = this.requireCoordinates(node);
        Polygon[] polygons = new Polygon[coordinates.size()];
        for (int i = 0; i < coordinates.size(); ++i) {
            polygons[i] = this.decodePolygonCoordinates(coordinates.get(i), fac);
        }
        return fac.createMultiPolygon(polygons);
    }

    protected GeometryCollection decodeGeometryCollection(JsonNode node, GeometryFactory fac) throws GeoJSONException {
        JsonNode geometries = node.path("geometries");
        if (!geometries.isArray()) {
            throw new GeoJSONException("expected 'geometries' array");
        }
        Geometry[] geoms = new Geometry[geometries.size()];
        for (int i = 0; i < geometries.size(); ++i) {
            geoms[i] = this.decodeGeometry(geometries.get(i), fac);
        }
        return fac.createGeometryCollection(geoms);
    }

    protected JsonNode requireCoordinates(JsonNode node) throws GeoJSONException {
        if (!node.path("coordinates").isArray()) {
            throw new GeoJSONException("missing 'coordinates' field");
        }
        return node.path("coordinates");
    }

    protected Coordinate decodeCoordinate(JsonNode node) throws GeoJSONException {
        int dim;
        if (!node.isArray()) {
            this.throwExpectedArrayException();
        }
        if ((dim = node.size()) < 2) {
            throw new GeoJSONException("coordinates may have at least 2 dimensions");
        }
        if (dim > 3) {
            throw new GeoJSONException("coordinates may have at most 3 dimensions");
        }
        Coordinate coordinate = new Coordinate();
        for (int i = 0; i < dim; ++i) {
            if (!node.get(i).isNumber()) {
                throw new GeoJSONException("coordinate index " + i + " has to be a number");
            }
            coordinate.setOrdinate(i, node.get(i).doubleValue());
        }
        return coordinate;
    }

    protected GeometryFactory getGeometryFactory(int srid, GeometryFactory factory) {
        if (srid == factory.getSRID()) {
            return factory;
        }
        return new GeometryFactory(DEFAULT_PRECISION_MODEL, srid);
    }

    protected GeometryFactory getGeometryFactory(JsonNode node, GeometryFactory factory) throws GeoJSONException {
        if (!node.hasNonNull("crs")) {
            return factory;
        }
        return this.decodeCRS(node, factory);
    }

    protected GeometryFactory decodeCRS(JsonNode node, GeometryFactory factory) throws GeoJSONException {
        if (!node.path("crs").hasNonNull("type")) {
            throw new GeoJSONException("Missing CRS type");
        }
        String type = node.path("crs").path("type").textValue();
        JsonNode properties = node.path("crs").path("properties");
        if (type.equals("name")) {
            return this.decodeNamedCRS(properties, factory);
        }
        if (type.equals("link")) {
            return this.decodeLinkedCRS(properties, factory);
        }
        throw new GeoJSONException("Unknown CRS type: " + type);
    }

    protected GeometryFactory decodeNamedCRS(JsonNode properties, GeometryFactory factory) throws GeoJSONException {
        String name = properties.path("name").textValue();
        if (name == null) {
            throw new GeoJSONException("Missing name attribute for name crs");
        }
        for (String prefix : SRS_NAME_PREFIXES) {
            if (!name.startsWith(prefix)) continue;
            try {
                int srid = Integer.parseInt(name.substring(prefix.length()));
                return this.getGeometryFactory(srid, factory);
            }
            catch (NumberFormatException e) {
                throw new GeoJSONException("Invalid CRS name", e);
            }
        }
        throw new GeoJSONException("Unsupported named crs: " + name);
    }

    protected GeometryFactory decodeLinkedCRS(JsonNode properties, GeometryFactory factory) throws GeoJSONException {
        String href = properties.path("href").textValue();
        if (href == null) {
            throw new GeoJSONException("Missing href attribute for link crs");
        }
        for (String prefix : SRS_LINK_PREFIXES) {
            if (!href.startsWith(prefix)) continue;
            try {
                int srid = Integer.parseInt(href.substring(prefix.length()));
                return this.getGeometryFactory(srid, factory);
            }
            catch (NumberFormatException e) {
                throw new GeoJSONException("Invalid CRS link", e);
            }
        }
        throw new GeoJSONException("Unsupported linked crs: " + href);
    }

    protected String getType(JsonNode node) throws GeoJSONException {
        if (!node.has("type")) {
            throw new GeoJSONException("Can not determine geometry type (missing 'type' field)");
        }
        if (!node.path("type").isTextual()) {
            throw new GeoJSONException("'type' field has to be a string");
        }
        return node.path("type").textValue();
    }

    protected boolean isNumber(JsonNode x) {
        return x == null || !x.isNumber();
    }

    private void throwExpectedArrayException() throws GeoJSONException {
        throw new GeoJSONException("expected array");
    }
}

