/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.geojson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.locationtech.jts.geom.Geometry;
import org.n52.io.geojson.GeoJSONEncoder;
import org.n52.io.geojson.GeoJSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoJSONGeometrySerializer
extends JsonSerializer<Geometry> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoJSONGeometrySerializer.class);

    public void serialize(Geometry geometry, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
        try {
            GeoJSONEncoder enc = new GeoJSONEncoder();
            gen.writeObject((Object)enc.encodeGeometry(geometry));
        }
        catch (GeoJSONException e) {
            LOGGER.error("could not properly encode geometry.", (Throwable)e);
        }
    }
}

