/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.request;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.n52.io.geojson.GeoJSONEncoder;
import org.n52.io.geojson.GeoJSONException;
import org.n52.io.request.BBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BBoxSerializer
extends JsonSerializer<BBox> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BBoxSerializer.class);

    public void serialize(BBox value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeObjectField("ll", this.encodeGeometry(value.getLl()));
        gen.writeObjectField("ur", this.encodeGeometry(value.getUr()));
        gen.writeEndObject();
    }

    private Object encodeGeometry(Point value) {
        try {
            GeoJSONEncoder enc = new GeoJSONEncoder();
            return enc.encodeGeometry((Geometry)value);
        }
        catch (GeoJSONException e) {
            LOGGER.error("could not properly encode geometry.", (Throwable)e);
            return null;
        }
    }
}

