/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.request;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import java.io.IOException;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.n52.io.geojson.GeoJSONDecoder;
import org.n52.io.geojson.GeoJSONException;
import org.n52.io.request.Vicinity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VicinityDeserializer
extends JsonDeserializer<Vicinity> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VicinityDeserializer.class);
    private static final String RADIUS = "radius";
    private static final String CENTER = "center";

    public Vicinity deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        Point center = (Point)this.decodeGeometry(this.getCenter(node));
        double radius = this.getRadius(node).asDouble(0.0);
        return new Vicinity(center, radius);
    }

    private JsonNode getCenter(JsonNode node) {
        return !node.path(CENTER).isObject() ? MissingNode.getInstance() : node.path(CENTER);
    }

    private JsonNode getRadius(JsonNode node) {
        return !node.path(RADIUS).isNumber() ? MissingNode.getInstance() : node.path(RADIUS);
    }

    private Geometry decodeGeometry(JsonNode value) {
        try {
            GeoJSONDecoder dec = new GeoJSONDecoder();
            return dec.decodeGeometry(value);
        }
        catch (GeoJSONException e) {
            LOGGER.error("could not properly decode geometry.", (Throwable)e);
            return null;
        }
    }
}

