/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.request;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.n52.io.geojson.GeoJSONEncoder;
import org.n52.io.geojson.GeoJSONException;
import org.n52.io.request.Vicinity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VicinitySerializer
extends JsonSerializer<Vicinity> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VicinitySerializer.class);

    public void serialize(Vicinity value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeNumberField("radius", value.getRadius());
        gen.writeObjectField("center", this.encodeGeometry(value));
        gen.writeEndObject();
    }

    private Object encodeGeometry(Vicinity value) {
        try {
            GeoJSONEncoder enc = new GeoJSONEncoder();
            Point geometry = value.getCenter();
            return enc.encodeGeometry((Geometry)geometry);
        }
        catch (GeoJSONException e) {
            LOGGER.error("could not properly encode geometry.", (Throwable)e);
            return null;
        }
    }
}

